/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.server.command.ratelimit;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.lopymine.patpat.PatTranslation;
import net.lopymine.patpat.extension.CommandExtension;
import net.lopymine.patpat.extension.GameProfileExtension;
import net.lopymine.patpat.extension.PlayerExtension;
import net.lopymine.patpat.server.config.PatPatServerConfig;
import net.lopymine.patpat.server.config.sub.PatPatServerRateLimitConfig;
import net.lopymine.patpat.server.ratelimit.PatPatServerRateLimitManager;
import net.lopymine.patpat.utils.CommandText;
import net.lopymine.patpat.utils.TextUtils;
import net.minecraft.class_11560;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class PatPatServerRateLimitInfoCommand {
    public static final String PROFILE_KEY = "profile";

    private PatPatServerRateLimitInfoCommand() {
        throw new IllegalStateException("Command class");
    }

    public static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(context -> CommandExtension.hasPatPatPermission(context, "ratelimit.info"))).executes(PatPatServerRateLimitInfoCommand::info)).then(class_2170.method_9244((String)PROFILE_KEY, (ArgumentType)class_2191.method_9329()).suggests((context, builder) -> class_2172.method_9265((Iterable)((class_2168)context.getSource()).method_9262(), (SuggestionsBuilder)builder)).executes(PatPatServerRateLimitInfoCommand::infoWithUser));
    }

    public static int info(CommandContext<class_2168> context) {
        PatPatServerRateLimitConfig config = PatPatServerConfig.getInstance().getRateLimitConfig();
        class_5250 statusComponent = PatTranslation.text("formatter.enabled_or_disabled." + config.isEnabled(), new Object[0]).method_27692(class_124.field_1065);
        Integer limitComponent = config.getTokenLimit();
        Integer incrementComponent = config.getTokenIncrement();
        String intervalComponent = config.getTokenIncrementInterval().toString();
        class_5250 permissionComponent = TextUtils.literal(config.getPermissionBypass()).method_27696(class_2583.field_24360.method_10949(CommandText.getHoverEvent(class_2568.class_5247.field_24342, CommandText.text("ratelimit.info.permission_bypass.copy", new Object[0]).finish())).method_10958(CommandText.getClickEvent(class_2558.class_2559.field_21462, config.getPermissionBypass())).method_10977(class_124.field_1065));
        CommandExtension.sendMsg(context, (class_2561)CommandText.goldenArgs("ratelimit.info.status", statusComponent).finish());
        CommandExtension.sendMsg(context, (class_2561)CommandText.goldenArgs("ratelimit.info.limit", limitComponent).finish());
        CommandExtension.sendMsg(context, (class_2561)CommandText.goldenArgs("ratelimit.info.increment", incrementComponent).finish());
        CommandExtension.sendMsg(context, (class_2561)CommandText.goldenArgs("ratelimit.info.interval", intervalComponent).finish());
        CommandExtension.sendMsg(context, (class_2561)CommandText.goldenArgs("ratelimit.info.permission_bypass", permissionComponent).finish());
        return 1;
    }

    public static int infoWithUser(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection profiles = class_2191.method_9330(context, (String)PROFILE_KEY);
        if (profiles.size() != 1) {
            class_5250 text = CommandText.text("error.only_one_player", new Object[0]).finish();
            CommandExtension.sendMsg(context, (class_2561)text);
        }
        PatPatServerRateLimitConfig config = PatPatServerConfig.getInstance().getRateLimitConfig();
        class_11560 profile = (class_11560)profiles.iterator().next();
        if (!((class_2168)context.getSource()).method_9262().contains(GameProfileExtension.getName(profile))) {
            class_5250 text = CommandText.goldenArgs("error.player_not_exist", GameProfileExtension.getName(profile)).finish();
            CommandExtension.sendMsg(context, (class_2561)text);
            return 0;
        }
        int availablePats = PatPatServerRateLimitManager.getAvailablePats(GameProfileExtension.getUUID(profile));
        PlayerExtension.hasPermission(profile, config.getPermissionBypass(), context).thenAcceptAsync(result -> {
            Integer arg = result != false ? CommandText.text("ratelimit.info.tokens.bypass", new Object[0]).finish().method_27692(class_124.field_1065) : Integer.valueOf(availablePats);
            PatPatServerRateLimitInfoCommand.sendInfo(context, profile, arg);
        });
        return 1;
    }

    private static void sendInfo(CommandContext<class_2168> context, class_11560 profile, Object tokens) {
        class_5250 text = CommandText.goldenArgs("ratelimit.info.player", GameProfileExtension.getName(profile)).finish();
        CommandExtension.sendMsg(context, (class_2561)text);
        class_5250 text2 = CommandText.goldenArgs("ratelimit.info.tokens", tokens).finish();
        CommandExtension.sendMsg(context, (class_2561)text2);
    }
}

