/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.render;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.lopymine.patpat.client.config.PatPatClientConfig;
import net.lopymine.patpat.client.config.PatPatClientStatsConfig;
import net.lopymine.patpat.client.config.resourcepack.CustomAnimationSettingsConfig;
import net.lopymine.patpat.client.config.resourcepack.FrameConfig;
import net.lopymine.patpat.client.config.resourcepack.PlayerConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientVisualConfig;
import net.lopymine.patpat.client.manager.PatPatClientManager;
import net.lopymine.patpat.client.packet.PatPatClientNetworkManager;
import net.lopymine.patpat.client.packet.PatPatClientPacketManager;
import net.lopymine.patpat.client.packet.PatPatClientProxLibPacketManager;
import net.lopymine.patpat.client.render.feature.PatFeatureRenderer;
import net.lopymine.patpat.client.resourcepack.PatPatClientSoundManager;
import net.lopymine.patpat.common.config.vector.Vec3f;
import net.lopymine.patpat.compat.flashback.FlashbackCompat;
import net.lopymine.patpat.compat.replaymod.ReplayModCompat;
import net.lopymine.patpat.entity.PatEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2879;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_898;
import net.minecraft.class_9064;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PatPatClientRenderer {
    private static final Queue<PatPacket> serverPats = new ConcurrentLinkedQueue<PatPacket>();
    private static final Queue<PatPacket> clientPats = new ConcurrentLinkedQueue<PatPacket>();

    public static void registerServerPacket(PatPacket packet) {
        serverPats.offer(packet);
    }

    public static void registerClientPacket(PatPacket packet) {
        clientPats.offer(packet);
    }

    public static void register() {
        ClientTickEvents.END_WORLD_TICK.register(client -> {
            class_746 player;
            PatPacket packet;
            boolean frozen = client.method_54719().method_54754();
            PatPatClientConfig config = PatPatClientConfig.getInstance();
            if (!frozen) {
                while ((packet = serverPats.poll()) != null) {
                    class_1309 pattedEntity = packet.pattedEntity();
                    PlayerConfig playerConfig = packet.playerConfig();
                    PatEntity patEntity = PatPatClientManager.pat(pattedEntity, playerConfig);
                    if (!config.getSoundsConfig().isSoundsEnabled() || packet.replayModPacket()) continue;
                    PatPatClientSoundManager.playSound(patEntity, (class_1657)packet.player(), config.getSoundsConfig().getSoundsVolume());
                }
            }
            boolean empty = clientPats.isEmpty();
            while ((packet = clientPats.poll()) != null) {
                player = packet.player();
                class_1309 pattedEntity = packet.pattedEntity();
                PlayerConfig playerConfig = packet.playerConfig();
                PatPatClientNetworkManager.sendPacketToServer(PatPatClientPacketManager.getPatPacket((class_1297)pattedEntity));
                PatEntity patEntity = PatPatClientManager.pat(pattedEntity, playerConfig);
                PatPatClientStatsConfig statsConfig = PatPatClientStatsConfig.getInstance();
                statsConfig.count(pattedEntity);
                PatPatClientVisualConfig visualConfig = config.getVisualConfig();
                if (visualConfig.isClientSwingHandEnabled()) {
                    player.method_23667(class_1268.field_5808, false);
                }
                if (visualConfig.isServerSwingHandEnabled() && !player.method_7325()) {
                    player.field_3944.method_52787((class_2596)new class_2879(class_1268.field_5808));
                }
                ReplayModCompat.onPat(pattedEntity.method_5628(), player.method_5628());
                FlashbackCompat.onPat(pattedEntity.method_5628(), player.method_5628());
                PatPatClientProxLibPacketManager.onPat(pattedEntity.method_5628());
                if (!config.getSoundsConfig().isSoundsEnabled()) continue;
                PatPatClientSoundManager.playSound(patEntity, (class_1657)player, config.getSoundsConfig().getSoundsVolume());
            }
            player = class_310.method_1551().field_1724;
            if (!empty && player != null && FabricLoader.getInstance().isDevelopmentEnvironment()) {
                PatPatClientManager.pat((class_1309)player, PlayerConfig.currentSession());
                ReplayModCompat.onPat(player.method_5628(), player.method_5628());
                FlashbackCompat.onPat(player.method_5628(), player.method_5628());
            }
            if (!frozen) {
                PatPatClientManager.tickEntities();
            }
        });
    }

    public static void renderPatOnYourself() {
        if (!PatPatClientConfig.getInstance().getVisualConfig().isCameraShackingEnabled()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        if (player == null || camera.method_19333()) {
            return;
        }
        class_898 dispatcher = class_310.method_1551().method_1561();
        float tickDelta = class_310.method_1551().method_61966().method_60637(false);
        int light = dispatcher.method_23839((class_1297)player, tickDelta);
        PatEntity patEntity = PatPatClientManager.getPatEntity((class_1309)player);
        if (patEntity == null) {
            return;
        }
        if (PatPatClientManager.expired(patEntity, tickDelta)) {
            PatPatClientManager.removePatEntity(patEntity);
            return;
        }
        PatPatClientRenderer.render(new class_4587(), camera.method_23767(), patEntity, (class_1297)player, new Vec3f(0.0f, class_3532.method_16439((float)tickDelta, (float)camera.field_18722, (float)camera.field_18721) - 0.2f, 0.0f), tickDelta, light);
    }

    public static RenderResult render(class_4587 matrices, Quaternionf cameraRotation, @Nullable PatEntity providedPatEntity, @Nullable class_1297 entity, @Nullable Vec3f overrideOffset, float tickDelta, int light) {
        PatPatClientConfig config = PatPatClientConfig.getInstance();
        if (!config.getMainConfig().isModEnabled()) {
            return RenderResult.FAILED;
        }
        PatEntity patEntity = providedPatEntity;
        if (patEntity == null && entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            patEntity = PatPatClientManager.getPatEntity(livingEntity);
        }
        if (patEntity == null) {
            return RenderResult.FAILED;
        }
        boolean numberToMirrorTexture = true;
        CustomAnimationSettingsConfig animation = patEntity.getAnimation();
        FrameConfig frameConfig = animation.getFrameConfig();
        PatPatClientRenderer.enableBlend();
        class_243 vec3d = entity != null ? entity.method_56072().method_55675(class_9064.field_47745, 0, entity.method_5705(tickDelta)) : null;
        float nameLabelHeight = vec3d != null ? (float)vec3d.field_1351 : 0.0f;
        float yOffset = overrideOffset != null ? overrideOffset.getY() : nameLabelHeight * PatPatClientManager.getAnimationProgress(patEntity, tickDelta) + 0.11f - frameConfig.offsetY() - config.getVisualConfig().getAnimationOffsets().getY();
        matrices.method_22903();
        matrices.method_46416(0.0f, yOffset, 0.0f);
        matrices.method_22907((Quaternionfc)cameraRotation);
        matrices.method_22905(0.85f * (float)numberToMirrorTexture, -0.85f, 0.85f);
        int frameWidth = animation.getTextureWidth() / frameConfig.totalFrames();
        int frameHeight = animation.getTextureHeight();
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (frameHeight > frameWidth) {
            scaleX = (float)frameWidth / (float)frameHeight;
        } else if (frameHeight < frameWidth) {
            scaleY = (float)frameHeight / (float)frameWidth;
        }
        float x1 = -((scaleX *= frameConfig.scaleX()) / 2.0f) + (overrideOffset != null ? overrideOffset.getX() : frameConfig.offsetX() + config.getVisualConfig().getAnimationOffsets().getX());
        float x2 = x1 + scaleX;
        float y1 = -((scaleY *= frameConfig.scaleY()) / 2.0f);
        float y2 = y1 + scaleY;
        float z = -(overrideOffset != null ? overrideOffset.getZ() : frameConfig.offsetZ() + config.getVisualConfig().getAnimationOffsets().getZ());
        float framePercent = 1.0f / (float)frameConfig.totalFrames();
        float u1 = (float)patEntity.getCurrentFrame() * framePercent;
        float u2 = u1 + framePercent;
        float v1 = 0.0f;
        float v2 = 1.0f;
        PatFeatureRenderer.getInstance().request(animation.getTexture(), matrices.method_23760(), x1, y1, x2, y2, z, u1, v1, u2, v2, light);
        matrices.method_22909();
        PatPatClientRenderer.disableBlend();
        if (config.getVisualConfig().isHidingNicknameEnabled()) {
            return RenderResult.RENDERER_SHOULD_CANCEL;
        }
        return RenderResult.RENDERED;
    }

    public static void scaleEntityIfPatted(class_1309 livingEntity, class_4587 matrixStack, float tickDelta) {
        PatEntity patEntity = PatPatClientManager.getPatEntity(livingEntity);
        if (patEntity == null) {
            return;
        }
        if (PatPatClientManager.expired(patEntity, tickDelta)) {
            PatPatClientManager.removePatEntity(patEntity);
            return;
        }
        matrixStack.method_22905(1.0f, PatPatClientManager.getAnimationProgress(patEntity, tickDelta), 1.0f);
    }

    private static void enableBlend() {
    }

    private static void disableBlend() {
    }

    public static enum RenderResult {
        RENDERED,
        RENDERER_SHOULD_CANCEL,
        FAILED;

    }

    public record PatPacket(class_1309 pattedEntity, PlayerConfig playerConfig, class_746 player, boolean replayModPacket) {
        @Override
        public String toString() {
            return "PatPacket{pattedEntity=" + this.pattedEntity.toString() + ", playerConfig=" + this.playerConfig.toString() + ", player=" + this.player.toString() + ", replayModPacket=" + this.replayModPacket + "}";
        }
    }
}

