/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.lopymine.patpat.client.command.PatPatClientCommandManager;
import net.lopymine.patpat.client.config.resourcepack.ListMode;
import net.lopymine.patpat.utils.CommandText;
import net.minecraft.class_2172;

public class ListModeArgumentType
implements ArgumentType<ListMode> {
    public static final DynamicCommandExceptionType FAILED_PARSING = new DynamicCommandExceptionType(o -> CommandText.text("error.failed_when_parsing", o).finish());

    private ListModeArgumentType() {
    }

    public static ListModeArgumentType listMode() {
        return new ListModeArgumentType();
    }

    public static <S> ListMode getListMode(CommandContext<S> context, String id) {
        return (ListMode)((Object)context.getArgument(id, ListMode.class));
    }

    public ListMode parse(StringReader reader) throws CommandSyntaxException {
        String modeId = reader.readUnquotedString();
        PatPatClientCommandManager.LOGGER.debug("Parsed ListMode from ListModeArgumentType: {}", modeId);
        ListMode listMode = ListMode.getById(modeId);
        if (listMode == null) {
            PatPatClientCommandManager.LOGGER.debug("Failed to find ListMode from parsed string: {}", modeId);
            throw FAILED_PARSING.createWithContext((ImmutableStringReader)reader, (Object)reader.getString());
        }
        return listMode;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(Arrays.stream(ListMode.values()).flatMap(listMode -> Stream.of(listMode.name())).toList(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Arrays.stream(ListMode.values()).flatMap(listMode -> Stream.of(listMode.name())).toList();
    }
}

