/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.util;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class VelocityProviders {
    private static Random random = new Random();

    public static Supplier<class_243> randomVelocityProvider(double magnitude) {
        return () -> new class_243((random.nextDouble() - 0.5) * 2.0 * magnitude, (random.nextDouble() - 0.5) * 2.0 * magnitude, (random.nextDouble() - 0.5) * 2.0 * magnitude);
    }

    public static Supplier<class_243> sphereVelocityProvider(float radius, Distribution radialDistribution) {
        return () -> {
            double adjustedRadius = radialDistribution.transform(radius);
            float theta = (float)Math.PI * 2 * random.nextFloat();
            float phi = (float)Math.acos(2.0f * random.nextFloat() - 1.0f);
            float sinPhi = class_3532.method_15374((float)phi);
            double x = adjustedRadius * (double)sinPhi * (double)class_3532.method_15362((float)theta);
            double z = adjustedRadius * (double)sinPhi * (double)class_3532.method_15374((float)theta);
            double y = adjustedRadius * Math.cos(phi);
            return new class_243(x, y, z);
        };
    }

    public static Supplier<class_243> hemisphereVelocityProvider(double radius, Distribution radialDistribution) {
        return () -> {
            double adjustedRadius = radialDistribution.transform(radius);
            float theta = (float)Math.PI * 2 * random.nextFloat();
            float phi = (float)Math.acos(random.nextFloat());
            float sinPhi = class_3532.method_15374((float)phi);
            double x = adjustedRadius * (double)sinPhi * (double)class_3532.method_15362((float)theta);
            double z = adjustedRadius * (double)sinPhi * (double)class_3532.method_15374((float)theta);
            double y = adjustedRadius * Math.cos(phi);
            return new class_243(x, y, z);
        };
    }

    public static enum Distribution {
        CONSTANT,
        UNIFORM,
        NORMAL(0.0f, 1.0f, 0.0f, Float.POSITIVE_INFINITY),
        TIGHT(0.5f, 0.25f, 0.25f, 2.0f);

        private float mean;
        private float standardDeviation;
        private float lowerBound;
        private float upperBound;

        private Distribution(float mean, float standardDeviation, float lowerBound, float upperBound) {
            this.mean = mean;
            this.standardDeviation = standardDeviation;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        private Distribution() {
        }

        private double transform(double value) {
            return switch (this.ordinal()) {
                case 0 -> value;
                case 1 -> random.nextDouble() * value;
                default -> class_3532.method_15350((double)((random.nextGaussian() * (double)this.mean + (double)this.standardDeviation) * value), (double)this.lowerBound, (double)this.upperBound);
            };
        }
    }
}

