/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.network;

import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.item.ThrowableLike;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class ThrowProjectileRequestPacket {
    protected UUID stateId;
    protected int slotIndex;

    public ThrowProjectileRequestPacket() {
    }

    public ThrowProjectileRequestPacket(UUID stateId, int slotIndex) {
        this.stateId = stateId;
        this.slotIndex = slotIndex;
    }

    public static <T extends ThrowProjectileRequestPacket> void encode(T packet, class_2540 buffer) {
        buffer.method_52974(packet.stateId.getMostSignificantBits());
        buffer.method_52974(packet.stateId.getLeastSignificantBits());
        buffer.method_53002(packet.slotIndex);
    }

    public <T extends ThrowProjectileRequestPacket> void handle(NetworkService.MessageContext ctx) {
        this.handleEnqueued(ctx);
    }

    public static ThrowProjectileRequestPacket decode(class_2540 buffer) {
        UUID stateId = new UUID(buffer.readLong(), buffer.readLong());
        int slotIndex = buffer.readInt();
        return new ThrowProjectileRequestPacket(stateId, slotIndex);
    }

    protected <T extends ThrowProjectileRequestPacket> void handleEnqueued(NetworkService.MessageContext ctx) {
        class_3222 player = (class_3222)ctx.getSender();
        if (player != null) {
            class_1799 itemStack = player.method_31548().method_5438(this.slotIndex);
            if (itemStack != null && itemStack.method_7909() instanceof ThrowableLike) {
                ((ThrowableLike)itemStack.method_7909()).handleClientThrowRequest(player, this.stateId, this.slotIndex);
            } else {
                System.err.println("Mismatching item in slot " + this.slotIndex);
            }
        }
    }
}

