/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.item;

import com.google.gson.JsonObject;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.AttachmentHost;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.client.render.AttachmentModelRenderer;
import com.vicmatskiv.pointblank.crafting.Craftable;
import com.vicmatskiv.pointblank.feature.Feature;
import com.vicmatskiv.pointblank.feature.FeatureBuilder;
import com.vicmatskiv.pointblank.feature.FeatureProvider;
import com.vicmatskiv.pointblank.feature.Features;
import com.vicmatskiv.pointblank.item.ItemBuilder;
import com.vicmatskiv.pointblank.registry.ItemRegistry;
import com.vicmatskiv.pointblank.util.JsonUtil;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.TimeUnit;
import com.vicmatskiv.pointblank.util.Tradeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_756;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public final class AttachmentItem
extends class_1792
implements GeoItem,
Attachment,
AttachmentHost,
FeatureProvider,
Craftable,
Tradeable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private String name;
    private AttachmentCategory category;
    private List<String> compatibleAttachmentGroups;
    private List<Supplier<Attachment>> compatibleAttachmentSuppliers;
    private List<Attachment> compatibleAttachments;
    private Set<String> groups;
    private Map<Class<? extends Feature>, Feature> features;
    private long craftingDuration;
    private float tradePrice;
    private int tradeBundleQuantity;
    private int tradeLevel;
    private List<class_2561> descriptionLines;
    public List<Supplier<Attachment>> defaultAttachmentSuppliers;

    public AttachmentItem() {
        super(new class_1792.class_1793().method_7889(1));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private AttachmentModelRenderer renderer;

            public class_756 getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new AttachmentModelRenderer(AttachmentItem.this.name);
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Feature> getFeatures() {
        return Collections.unmodifiableCollection(this.features.values());
    }

    @Override
    public List<class_2561> getDescriptionTooltipLines() {
        return this.descriptionLines;
    }

    public void method_7851(class_1799 p_41421_, class_1792.class_9635 p_333372_, List<class_2561> p_41423_, class_1836 p_41424_) {
    }

    @Override
    public AttachmentCategory getCategory() {
        return this.category;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups;
    }

    public int method_7882() {
        return 1;
    }

    @Override
    public Collection<Attachment> getCompatibleAttachments() {
        if (this.compatibleAttachments == null) {
            this.compatibleAttachments = new ArrayList<Attachment>();
            for (Supplier<Attachment> cas : this.compatibleAttachmentSuppliers) {
                this.compatibleAttachments.add(cas.get());
            }
            for (String group : this.compatibleAttachmentGroups) {
                List<Supplier<? extends class_1792>> groupAtttachments = ItemRegistry.ITEMS.getAttachmentsForGroup(group);
                for (Supplier<? extends class_1792> ga : groupAtttachments) {
                    class_1792 item = ga.get();
                    if (!(item instanceof Attachment)) continue;
                    Attachment attachment = (Attachment)item;
                    this.compatibleAttachments.add(attachment);
                }
            }
        }
        return this.compatibleAttachments;
    }

    public class_2561 method_7864(class_1799 itemStack) {
        return class_2561.method_43471((String)this.method_7866(itemStack));
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> featureClass) {
        return (T)((Feature)featureClass.cast(this.features.get(featureClass)));
    }

    @Override
    public long getCraftingDuration() {
        return this.craftingDuration;
    }

    @Override
    public float getPrice() {
        return this.tradePrice;
    }

    @Override
    public int getTradeLevel() {
        return this.tradeLevel;
    }

    @Override
    public int getBundleQuantity() {
        return this.tradeBundleQuantity;
    }

    public List<Attachment> getDefaultAttachments() {
        return this.defaultAttachmentSuppliers.stream().map(Supplier::get).toList();
    }

    public void method_7888(class_1799 itemStack, class_1937 level, class_1297 entity, int itemSlot, boolean isSelected) {
        if (!level.field_9236) {
            this.ensureItemStack(itemStack);
        }
    }

    public void ensureItemStack(class_1799 itemStack) {
        class_2487 stateTag = MiscUtil.getTag(itemStack);
        if (stateTag == null) {
            stateTag = new class_2487();
            class_1792 class_17922 = itemStack.method_7909();
            if (class_17922 instanceof AttachmentHost) {
                AttachmentHost attachmentHost = (AttachmentHost)class_17922;
                Collection<Attachment> defaultAttachments = attachmentHost.getDefaultAttachments();
                for (Attachment attachment : defaultAttachments) {
                    Attachments.addAttachment(itemStack, new class_1799((class_1935)attachment), true);
                }
            }
            MiscUtil.setTag(itemStack, stateTag);
        }
    }

    public static class Builder
    extends ItemBuilder<Builder> {
        private static final int DEFAULT_CRAFTING_DURATION = 750;
        private static final float DEFAULT_PRICE = Float.NaN;
        private static final int DEFAULT_TRADE_LEVEL = 0;
        private static final int DEFAULT_TRADE_BUNDLE_QUANTITY = 1;
        private String name;
        private AttachmentCategory category;
        private List<Supplier<Attachment>> compatibleAttachmentSuppliers = new ArrayList<Supplier<Attachment>>();
        private List<String> compatibleAttachmentGroups = new ArrayList<String>();
        private Set<String> groups = new HashSet<String>();
        private List<FeatureBuilder<?, ?>> featureBuilders = new ArrayList();
        private long craftingDuration = 750L;
        private float tradePrice = Float.NaN;
        private int tradeBundleQuantity = 1;
        private int tradeLevel = 0;
        private List<class_2561> descriptionLines = new ArrayList<class_2561>();
        private List<Supplier<Attachment>> defaultAttachments = new ArrayList<Supplier<Attachment>>();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCategory(String categoryName) {
            this.category = AttachmentCategory.fromString(categoryName);
            return this;
        }

        public Builder withCategory(AttachmentCategory category) {
            this.category = category;
            return this;
        }

        public Builder withDescription(class_2561 description) {
            this.descriptionLines.add(description);
            return this;
        }

        public Builder withDescription(String description) {
            this.descriptionLines.add((class_2561)class_2561.method_43471((String)description).method_27692(class_124.field_1061).method_27692(class_124.field_1056));
            return this;
        }

        public Builder withFeature(FeatureBuilder<?, ?> featureBuilder) {
            this.featureBuilders.add(featureBuilder);
            return this;
        }

        @SafeVarargs
        public final Builder withCompatibleAttachment(Supplier<? extends Attachment> ... attachmentSuppliers) {
            for (Supplier<? extends Attachment> s : attachmentSuppliers) {
                this.compatibleAttachmentSuppliers.add(s::get);
            }
            return this;
        }

        public Builder withCompatibleAttachmentGroup(String ... groups) {
            this.compatibleAttachmentGroups.addAll(Set.of(groups));
            return this;
        }

        public Builder withGroup(String ... groups) {
            this.groups.addAll(Set.of(groups));
            return this;
        }

        public Builder withCraftingDuration(int duration, TimeUnit timeUnit) {
            this.craftingDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withTradePrice(double price, int tradeLevel) {
            this.tradePrice = (float)price;
            this.tradeLevel = tradeLevel;
            this.tradeBundleQuantity = 1;
            return this;
        }

        public Set<String> getGroups() {
            return Collections.unmodifiableSet(this.groups);
        }

        @SafeVarargs
        public final Builder withDefaultAttachment(Supplier<? extends Attachment> ... attachmentSuppliers) {
            for (Supplier<? extends Attachment> s : attachmentSuppliers) {
                this.defaultAttachments.add(s::get);
            }
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj, boolean isClientSide) {
            this.withName(JsonUtil.getJsonString(obj, "name"));
            this.withCategory(JsonUtil.getJsonString(obj, "category"));
            this.withTradePrice(JsonUtil.getJsonFloat(obj, "tradePrice", Float.NaN), JsonUtil.getJsonInt(obj, "tradeLevel", 0));
            this.withCraftingDuration(JsonUtil.getJsonInt(obj, "craftingDuration", 750), TimeUnit.MILLISECOND);
            List<String> groups = JsonUtil.getStrings(obj, "groups");
            this.groups.addAll(groups);
            for (JsonObject jsonObject : JsonUtil.getJsonObjects(obj, "features")) {
                FeatureBuilder<?, ?> featureBuilder = Features.fromJson(jsonObject);
                this.withFeature(featureBuilder);
            }
            List<String> compatibleAttachmentNames = JsonUtil.getStrings(obj, "compatibleAttachments");
            for (String compatibleAttachmentName : compatibleAttachmentNames) {
                Supplier ri = ItemRegistry.ITEMS.getDeferredRegisteredObject(compatibleAttachmentName);
                if (ri == null) continue;
                this.withCompatibleAttachment(() -> (Attachment)ri.get());
            }
            List<String> list = JsonUtil.getStrings(obj, "compatibleAttachmentGroups");
            this.compatibleAttachmentGroups.addAll(list);
            List<String> defaultAttachmentNames = JsonUtil.getStrings(obj, "defaultAttachments");
            for (String defaultAttachmentName : defaultAttachmentNames) {
                Supplier ri = ItemRegistry.ITEMS.getDeferredRegisteredObject(defaultAttachmentName);
                if (ri == null) continue;
                this.withDefaultAttachment(() -> (Attachment)ri.get());
            }
            return this;
        }

        @Override
        public AttachmentItem build() {
            Object feature;
            if (this.name == null) {
                throw new IllegalStateException("Attachment name not set");
            }
            if (this.category == null) {
                throw new IllegalStateException("Attachment category not set");
            }
            AttachmentItem attachment = new AttachmentItem();
            attachment.name = this.name;
            attachment.descriptionLines = Collections.unmodifiableList(this.descriptionLines);
            attachment.category = this.category;
            attachment.compatibleAttachmentSuppliers = Collections.unmodifiableList(this.compatibleAttachmentSuppliers);
            attachment.compatibleAttachmentGroups = Collections.unmodifiableList(this.compatibleAttachmentGroups);
            attachment.groups = Collections.unmodifiableSet(this.groups);
            HashMap features = new HashMap();
            for (FeatureBuilder<?, ?> featureBuilder : this.category.getDefaultFeatures()) {
                feature = featureBuilder.build(attachment);
                features.put(feature.getClass(), feature);
            }
            for (FeatureBuilder<?, ?> featureBuilder : this.featureBuilders) {
                feature = featureBuilder.build(attachment);
                features.put(feature.getClass(), feature);
            }
            attachment.features = Collections.unmodifiableMap(features);
            attachment.craftingDuration = this.craftingDuration;
            attachment.tradePrice = this.tradePrice;
            attachment.tradeBundleQuantity = this.tradeBundleQuantity;
            attachment.tradeLevel = this.tradeLevel;
            attachment.defaultAttachmentSuppliers = Collections.unmodifiableList(this.defaultAttachments);
            return attachment;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

