/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.inventory;

import com.vicmatskiv.pointblank.block.entity.PrinterBlockEntity;
import com.vicmatskiv.pointblank.crafting.PointBlankIngredient;
import com.vicmatskiv.pointblank.crafting.PointBlankRecipe;
import com.vicmatskiv.pointblank.event.MenuRegistry;
import com.vicmatskiv.pointblank.inventory.IngredientSlot;
import com.vicmatskiv.pointblank.inventory.SearchSlot;
import com.vicmatskiv.pointblank.registry.ItemRegistry;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.InventoryUtils;
import com.vicmatskiv.pointblank.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1126;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import net.minecraft.class_7923;

public class CraftingContainerMenu
extends class_1703 {
    private static final int SEARCH_COLS = 6;
    private static final int SEARCH_ROWS = 7;
    private static final int INGREDIENT_COLS = 5;
    private static final int INGREDIENT_ROWS = 2;
    public static final class_1277 INGREDIENT_CONTAINER = new class_1277(10);
    public static final class_1277 SEARCH_CONTAINER = new class_1277(42);
    private final class_2371<class_1799> items = class_2371.method_10211();
    private final class_1703 inventoryMenu;
    private List<class_1799> displayItems = new ArrayList<class_1799>();
    private PrinterBlockEntity craftingBlockEntity;
    private class_3913 containerData;
    private class_1126<class_1799> searchTree;
    private class_1657 player;

    public CraftingContainerMenu(int containerId, class_1661 playerInventory) {
        this(containerId, playerInventory, null, (class_3913)new class_3919(2));
    }

    public CraftingContainerMenu(int containerId, class_1661 playerInventory, PrinterBlockEntity craftingBlockEntity, class_3913 dataAccess) {
        super(MenuRegistry.CRAFTING.get(), containerId);
        class_1735 slot;
        int j;
        int i;
        this.craftingBlockEntity = craftingBlockEntity;
        this.containerData = dataAccess;
        this.player = playerInventory.field_7546;
        this.inventoryMenu = playerInventory.field_7546.field_7498;
        this.method_17360(dataAccess);
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 6; ++j) {
                slot = new SearchSlot((class_1263)SEARCH_CONTAINER, i * 6 + j, 9 + j * 18, 18 + i * 18, true);
                this.method_7621(slot);
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 5; ++j) {
                slot = new IngredientSlot((class_1263)INGREDIENT_CONTAINER, i * 5 + j, 151 + j * 18, 108 + i * 18);
                this.method_7621(slot);
            }
        }
        for (Supplier<? extends class_1792> itemSupplier : ItemRegistry.ITEMS.getItemsByName().values()) {
            class_1792 item = itemSupplier.get();
            PointBlankRecipe recipe = PointBlankRecipe.getRecipe(playerInventory.field_7546.method_37908(), item);
            if (recipe == null) continue;
            this.displayItems.add(recipe.getInitializedStack());
        }
        if (MiscUtil.isClientSide((class_1297)playerInventory.field_7546)) {
            this.searchTree = new class_1126(itemStack -> itemStack.method_7950(class_1792.class_9635.method_59528((class_1937)ClientUtil.getClientLevel()), playerInventory.field_7546, (class_1836)class_1836.class_1837.field_41070.method_47371()).stream().map(component -> class_124.method_539((String)component.getString()).trim()).filter(p_210809_ -> !p_210809_.isEmpty()), itemStack -> Stream.of(class_7923.field_41178.method_10221((Object)itemStack.method_7909())), this.displayItems);
        }
        this.scrollTo(0.0f);
    }

    public PrinterBlockEntity getWorkstationBlockEntity() {
        return this.craftingBlockEntity;
    }

    public void method_7619(int slotIndex, int stateId, class_1799 itemStack) {
        super.method_7619(slotIndex, stateId, itemStack);
    }

    public void method_7610(int stateId, List<class_1799> itemStacks, class_1799 carriedStack) {
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    protected int calculateRowCount() {
        return class_3532.method_38788((int)this.items.size(), (int)6) - 7;
    }

    public int getRowIndexForScroll(float scroll) {
        return Math.max((int)((double)(scroll * (float)this.calculateRowCount()) + 0.5), 0);
    }

    public float getScrollForRowIndex(int rowIndex) {
        return class_3532.method_15363((float)((float)rowIndex / (float)this.calculateRowCount()), (float)0.0f, (float)1.0f);
    }

    public float subtractInputFromScroll(float scrolloffs, double scroll) {
        return class_3532.method_15363((float)(scrolloffs - (float)(scroll / (double)this.calculateRowCount())), (float)0.0f, (float)1.0f);
    }

    public void scrollTo(float scroll) {
        int i = this.getRowIndexForScroll(scroll);
        for (int j = 0; j < 7; ++j) {
            for (int k = 0; k < 6; ++k) {
                int l = k + (j + i) * 6;
                if (l >= 0 && l < this.items.size()) {
                    SEARCH_CONTAINER.method_5447(k + j * 6, (class_1799)this.items.get(l));
                    continue;
                }
                SEARCH_CONTAINER.method_5447(k + j * 6, class_1799.field_8037);
            }
        }
    }

    public boolean canScroll() {
        return this.items.size() > 42;
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1735 slot;
        if (slotIndex >= this.field_7761.size() - 6 && slotIndex < this.field_7761.size() && (slot = (class_1735)this.field_7761.get(slotIndex)) != null && slot.method_7681()) {
            slot.method_53512(class_1799.field_8037);
        }
        return class_1799.field_8037;
    }

    public boolean method_7613(class_1799 itemStack, class_1735 slot) {
        return slot.field_7871 != SEARCH_CONTAINER;
    }

    public boolean method_7615(class_1735 p_98653_) {
        return p_98653_.field_7871 != SEARCH_CONTAINER;
    }

    public class_1799 method_34255() {
        return this.inventoryMenu.method_34255();
    }

    public void method_34254(class_1799 itemStack) {
        this.inventoryMenu.method_34254(itemStack);
    }

    public void refreshSearchResults(String s) {
        this.items.clear();
        if (s.isEmpty()) {
            this.items.addAll(this.displayItems);
        } else {
            this.items.addAll((Collection)this.searchTree.method_4810(s.toLowerCase(Locale.ROOT)));
        }
        this.scrollTo(0.0f);
    }

    public boolean updateIngredientSlots(PointBlankRecipe selectedItemRecipe) {
        boolean isCraftable = true;
        List<PointBlankIngredient> ingredients = selectedItemRecipe.getPointBlankIngredients();
        if (ingredients.size() <= INGREDIENT_CONTAINER.method_5439()) {
            int ingredientSlotOffset = SEARCH_CONTAINER.method_5439();
            for (int i = 0; i < ingredients.size(); ++i) {
                PointBlankIngredient ingredient = ingredients.get(i);
                IngredientSlot ingredientSlot = (IngredientSlot)((Object)this.field_7761.get(ingredientSlotOffset + i));
                boolean hasIngredient = InventoryUtils.hasIngredient(ClientUtil.getClientPlayer(), ingredient);
                ingredientSlot.setIngredient(ingredient, hasIngredient);
                isCraftable &= hasIngredient;
            }
        }
        return isCraftable;
    }

    public void clearIngredientSlots() {
        int ingredientSlotOffset = SEARCH_CONTAINER.method_5439();
        for (int i = 0; i < INGREDIENT_CONTAINER.method_5439(); ++i) {
            IngredientSlot ingredientSlot = (IngredientSlot)((Object)this.field_7761.get(ingredientSlotOffset + i));
            ingredientSlot.setIngredient(null, true);
        }
        INGREDIENT_CONTAINER.method_5448();
    }

    public boolean isCreativeSlot(class_1735 slot) {
        return slot != null && slot.field_7871 == SEARCH_CONTAINER;
    }

    public boolean isIdle() {
        return PrinterBlockEntity.State.values()[this.containerData.method_17390(0)] == PrinterBlockEntity.State.IDLE;
    }

    public boolean isCrafting() {
        boolean result = false;
        PrinterBlockEntity.State state = PrinterBlockEntity.State.values()[this.containerData.method_17390(0)];
        if (state == PrinterBlockEntity.State.CRAFTING) {
            class_1937 level = MiscUtil.getLevel((class_1297)this.player);
            int playerEntityId = this.containerData.method_17390(1);
            if (playerEntityId >= 0) {
                result = this.player == level.method_8469(playerEntityId);
            }
        }
        return result;
    }
}

