/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.compat.playeranimator;

import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.compat.playeranimator.PlayerAnimation;
import com.vicmatskiv.pointblank.compat.playeranimator.PlayerAnimationPartGroup;
import com.vicmatskiv.pointblank.compat.playeranimator.PlayerAnimationRegistry;
import com.vicmatskiv.pointblank.compat.playeranimator.PlayerAnimationType;
import com.vicmatskiv.pointblank.util.ModInfo;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PlayerAnimatorCompat
implements class_4013 {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static PlayerAnimatorCompat instance;
    private Function<List<PlayerAnimationType>, List<String>> animationsToPlay;
    private static final PlayerAnimationRegistry<?> noOpRegistry;

    public static PlayerAnimatorCompat getInstance() {
        if (instance == null) {
            ModInfo modInfo = Platform.getInstance().getModInfo("playeranimator");
            if (modInfo != null) {
                String playerAnimatorClassName = "com.vicmatskiv.pointblank.compat.playeranimator.PlayerAnimatorCompatImpl";
                try {
                    Class<?> playerAnimatorClass = Class.forName(playerAnimatorClassName);
                    instance = (PlayerAnimatorCompat)playerAnimatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    LOGGER.info("Compatibility with Player Animator version {} enabled", (Object)modInfo.getVersion());
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    LOGGER.error("Player Animator mod version {} detected, but compatibility could not be enabled. This is likely due to an outdated and/or incompatible version of the Player Animator mod. ", (Object)modInfo.getVersion(), (Object)e);
                }
            }
            if (instance == null) {
                instance = new PlayerAnimatorCompat(){};
            }
        }
        return instance;
    }

    protected PlayerAnimatorCompat() {
        this.init();
    }

    protected void init() {
        this.animationsToPlay = class_156.method_34866(PlayerAnimatorCompat::getAnimationsToPlay);
    }

    public void method_14491(class_3300 resourceManager) {
        this.init();
    }

    public boolean isPlayerAnimatorLoaded() {
        return false;
    }

    public void registerAnimationTypes() {
    }

    public boolean isEnabled() {
        return false;
    }

    public PlayerAnimationRegistry<?> getAnimationRegistry() {
        return noOpRegistry;
    }

    public void handlePlayerThirdPersonMovement(class_1657 player, float partialTick) {
    }

    public void playAnimation(class_1657 player, String ownerId, String animationName) {
    }

    public void stopAnimation(class_1657 player, PlayerAnimationPartGroup animationLayerType) {
    }

    public void clearAll(class_1657 player) {
    }

    protected void aux(class_1657 player) {
    }

    public void playEnsemble(class_1657 player, String ownerId, List<PlayerAnimationType> animationTypes) {
        List<String> animationNames = this.animationsToPlay.apply(animationTypes);
        LOGGER.trace("Playing animations: {}", animationNames);
        for (String animationName : animationNames) {
            this.playAnimation(player, ownerId, animationName);
        }
        this.aux(player);
    }

    private static List<String> getAnimationsToPlay(List<PlayerAnimationType> types) {
        ArrayList<String> animationsToPlay = new ArrayList<String>();
        for (Map.Entry<PlayerAnimationPartGroup, PlayerAnimationType> e : PlayerAnimationType.compose(types).entrySet()) {
            PlayerAnimationPartGroup group = e.getKey();
            PlayerAnimationType animationType = e.getValue();
            String animationName = PlayerAnimatorCompat.constructAnimationName(animationType.getBaseAnimationName(), group);
            animationsToPlay.add(animationName);
        }
        return animationsToPlay;
    }

    private static String constructAnimationName(String baseAnimationName, PlayerAnimationPartGroup group) {
        return baseAnimationName + "." + group.getGroupName();
    }

    static {
        noOpRegistry = new PlayerAnimationRegistry<Object>(){

            @Override
            public void register(String ownerId, Supplier<InputStream> reader) {
            }

            @Override
            public boolean isRegistered(String ownerId) {
                return false;
            }

            @Override
            public List<PlayerAnimation<Object>> getAnimations(String ownerId, PlayerAnimationType animationType) {
                return Collections.emptyList();
            }

            @Override
            public void reload() {
            }
        };
    }
}

