/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render.layer;

import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.AttachmentHost;
import com.vicmatskiv.pointblank.attachment.AttachmentModelInfo;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.gui.AttachmentManagerScreen;
import com.vicmatskiv.pointblank.client.render.HierarchicalRenderContext;
import com.vicmatskiv.pointblank.client.render.RenderApprover;
import com.vicmatskiv.pointblank.client.render.RenderPass;
import com.vicmatskiv.pointblank.client.render.RenderPassGeoRenderer;
import com.vicmatskiv.pointblank.client.render.RenderPassRenderer;
import com.vicmatskiv.pointblank.client.render.layer.FeaturePassLayer;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class AttachmentLayer<T extends GeoAnimatable>
extends FeaturePassLayer<T> {
    private static final Vector4f COLOR_GREEN = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
    private static final Vector4f COLOR_NORMAL = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private RenderPassRenderer<T> currentRenderer;
    private RenderPassGeoRenderer<T> mainRenderer;

    public AttachmentLayer(RenderPassGeoRenderer<T> renderer) {
        super(renderer, null, RenderPass.ATTACHMENTS, ALL_PARTS, true, null);
        this.mainRenderer = renderer;
    }

    @Override
    public void render(class_4587 poseStack, T animatable, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!(animatable instanceof AttachmentHost)) {
            return;
        }
        class_1799 rootStack = HierarchicalRenderContext.current().getItemStack();
        this.currentRenderer = this.mainRenderer;
        this.renderPass(() -> {
            this.renderAttachments(null, null, animatable, "/", rootStack, poseStack, bufferSource, buffer, partialTick, packedLight, packedOverlay);
            for (GeoRenderLayer effectLayer : this.mainRenderer.getRenderLayers()) {
                GunClientState state;
                RenderPassRenderer renderPassRenderer;
                if (effectLayer == this || !(effectLayer instanceof RenderPassRenderer) || !(renderPassRenderer = (RenderPassRenderer)effectLayer).isEffectLayer() || (state = GunClientState.getMainHeldState()) == null) continue;
                renderPassRenderer.renderPass(() -> {
                    this.currentRenderer = renderPassRenderer;
                    this.renderAttachments(state, null, animatable, "/", rootStack, poseStack, bufferSource, buffer, partialTick, packedLight, packedOverlay);
                    this.currentRenderer = null;
                });
            }
        });
    }

    public void renderAttachments(GunClientState state, class_1921 renderTypeOverride, T gunItem, String parentPath, class_1799 baseItemStack, class_4587 poseStack, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        class_1792 class_17922 = baseItemStack.method_7909();
        if (!(class_17922 instanceof AttachmentHost)) {
            return;
        }
        AttachmentHost attachmentHost = (AttachmentHost)class_17922;
        Collection<class_1799> attachmentItemStacks = Attachments.getAttachments(baseItemStack);
        for (class_1799 attachmentItemStack : attachmentItemStacks) {
            Attachment attachment;
            AttachmentModelInfo attachmentInfo;
            class_1792 class_17923 = attachmentItemStack.method_7909();
            if (!(class_17923 instanceof Attachment) || (attachmentInfo = (AttachmentModelInfo)AttachmentModelInfo.attachmentInfos.apply(attachmentHost, attachment = (Attachment)class_17923).orElse(null)) == null) continue;
            this.renderAttachment(state, renderTypeOverride, gunItem, parentPath, baseItemStack, attachmentInfo.baseModel(), attachmentInfo.baseBone(), attachmentItemStack, attachmentInfo.attachmentModel(), attachmentInfo.attachmentBone(), poseStack, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
    }

    protected void renderAttachment(GunClientState state, class_1921 renderTypeOverride, T gunItem, String parentPath, class_1799 baseItemStack, BakedGeoModel baseModel, GeoBone baseBone, class_1799 attachmentItemStack, BakedGeoModel attachmentModel, GeoBone attachmentBone, class_4587 poseStack, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        class_1792 class_17922 = attachmentItemStack.method_7909();
        if (!(class_17922 instanceof Attachment)) {
            return;
        }
        Attachment attachment = (Attachment)class_17922;
        class_811 itemDisplayContext = HierarchicalRenderContext.current().getItemDisplayContext();
        try (HierarchicalRenderContext hrc = HierarchicalRenderContext.push(attachmentItemStack, itemDisplayContext);){
            String attachmentPath = parentPath + "/" + attachment.getName();
            Pair basePos = AttachmentModelInfo.modelBonePositions.apply(new AttachmentModelInfo.ModelBoneKey(baseModel, baseBone.getName(), 1.0f)).orElse(null);
            Pair attachmentPos = AttachmentModelInfo.modelBonePositions.apply(new AttachmentModelInfo.ModelBoneKey(attachmentModel, attachmentBone.getName(), 1.0f)).orElse(null);
            if (basePos != null && attachmentPos != null) {
                class_1921 attachmentRenderType = null;
                Vector4f color = COLOR_NORMAL;
                if (renderTypeOverride == null) {
                    Pair<class_1921, Vector4f> p = this.getRenderType(baseItemStack, attachmentItemStack, attachment.getName(), attachmentPath, itemDisplayContext);
                    attachmentRenderType = (class_1921)p.getFirst();
                    color = (Vector4f)p.getSecond();
                } else {
                    attachmentRenderType = renderTypeOverride;
                    color = COLOR_GREEN;
                }
                if (attachmentRenderType != null) {
                    poseStack.method_22903();
                    AttachmentModelInfo.preparePoseStackForBoneInHierarchy(poseStack, baseBone);
                    poseStack.method_34425((Matrix4f)basePos.getFirst());
                    poseStack.method_34425((Matrix4f)attachmentPos.getSecond());
                    this.currentRenderer.render(attachmentModel, poseStack, bufferSource, gunItem, attachmentRenderType, bufferSource.getBuffer(attachmentRenderType), partialTick, packedLight, class_4608.field_21444, color.x, color.y, color.z, color.w);
                    this.renderAttachments(state, renderTypeOverride, gunItem, attachmentPath, attachmentItemStack, poseStack, bufferSource, buffer, partialTick, packedLight, packedOverlay);
                    poseStack.method_22909();
                }
            }
        }
    }

    private Pair<class_1921, Vector4f> getRenderType(class_1799 baseItemStack, class_1799 attachmentItemStack, String attachmentName, String attachmentPath, class_811 itemDisplayContext) {
        AttachmentManagerScreen ams;
        Pair<class_1921, Vector4f> p;
        class_437 class_4372;
        class_1921 renderType = null;
        class_2960 texture = class_2960.method_60655((String)"pointblank", (String)("textures/item/" + attachmentName + ".png"));
        Vector4f color = null;
        class_310 mc = class_310.method_1551();
        if (itemDisplayContext == class_811.field_4318 && (class_4372 = mc.field_1755) instanceof AttachmentManagerScreen && (p = (ams = (AttachmentManagerScreen)class_4372).getRenderTypeOverride(baseItemStack, attachmentItemStack, attachmentName, attachmentPath)) != null) {
            renderType = (class_1921)p.getFirst();
            color = (Vector4f)p.getSecond();
        }
        if (renderType == null) {
            renderType = this.currentRenderer.getRenderType();
        }
        if (renderType == null) {
            renderType = class_1921.method_23578((class_2960)texture);
        }
        if (color == null) {
            color = COLOR_NORMAL;
        }
        return Pair.of((Object)renderType, (Object)color);
    }

    @Override
    public boolean approveRendering(RenderPass renderPass, String boneName, class_1799 rootStack, class_1799 currentStack, String path, class_811 itemDisplayContext) {
        if (renderPass == RenderPass.ATTACHMENTS) {
            return true;
        }
        HierarchicalRenderContext hrc = HierarchicalRenderContext.current();
        class_1792 class_17922 = hrc.getItemStack().method_7909();
        if (!(class_17922 instanceof Attachment)) {
            return true;
        }
        Attachment currentAttachment = (Attachment)class_17922;
        AttachmentCategory category = currentAttachment.getCategory();
        Pair<String, class_1799> activeCategoryAttachment = Attachments.getSelectedAttachment(rootStack, category);
        if (activeCategoryAttachment != null && !Objects.equals(activeCategoryAttachment.getFirst(), hrc.getPath())) {
            return false;
        }
        RenderPassRenderer<T> renderPassRenderer = this.currentRenderer;
        if (!(renderPassRenderer instanceof RenderApprover)) {
            return true;
        }
        RenderApprover renderApprover = (RenderApprover)((Object)renderPassRenderer);
        return renderApprover.approveRendering(renderPass, boneName, rootStack, currentStack, path, itemDisplayContext);
    }

    @Override
    public class_1921 getRenderType() {
        return null;
    }

    @Override
    public boolean isSupportedItemDisplayContext(class_811 context) {
        return context != class_811.field_4317;
    }
}

