/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.AttachmentHost;
import com.vicmatskiv.pointblank.client.gui.MouseInteractionHandler;
import com.vicmatskiv.pointblank.event.AttachmentAddedEvent;
import com.vicmatskiv.pointblank.event.AttachmentRemovedEvent;
import com.vicmatskiv.pointblank.event.EventBus;
import com.vicmatskiv.pointblank.event.EventListener;
import com.vicmatskiv.pointblank.inventory.AttachmentContainerMenu;
import com.vicmatskiv.pointblank.inventory.AttachmentSlot;
import com.vicmatskiv.pointblank.inventory.HierarchicalSlot;
import com.vicmatskiv.pointblank.inventory.SimpleAttachmentContainer;
import com.vicmatskiv.pointblank.registry.SoundRegistry;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.MiscUtil;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_465;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;

public class AttachmentManagerScreen
extends class_465<AttachmentContainerMenu> {
    private static final class_2960 GUI_TEXTURES = class_2960.method_60655((String)"pointblank", (String)"textures/gui/attachments4.png");
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"pointblank", (String)"textures/gui/blueprint-background-2.png");
    protected static final class_2960 WIDGETS_LOCATION = class_2960.method_60654((String)"textures/gui/widgets.png");
    private static final Vector4f COLOR_GREEN = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
    private final class_1661 playerInventory;
    private MouseInteractionHandler mouseInteractionHandler;
    private final int inventoryWidth = 176;
    private final int inventoryHeight = 90;
    private final int slotWidth = 18;
    private final int slotHeight = 18;
    private final int slotRightPadding = 4;
    private int headerBottomPadding = 2;
    private AttachmentContainerMenu menu;
    private String selectedAttachmentPath;
    private Queue<AttachmentHighlightEvent> attachmentEventQueue = new ArrayDeque<AttachmentHighlightEvent>();
    private EventListener attachmentAddedListener;
    private EventListener attachmentRemovedListener;

    public AttachmentManagerScreen(AttachmentContainerMenu menu, class_1661 playerInventory, class_2561 titleIn) {
        super((class_1703)menu, playerInventory, titleIn);
        this.menu = menu;
        this.playerInventory = playerInventory;
        this.field_2779 = 250;
        this.field_2792 = 370;
        this.mouseInteractionHandler = new MouseInteractionHandler(this::isMouseInScreen, 0.5f, 2.0f, 0.1f);
        EventBus eventBus = Platform.getInstance().getEventBus();
        this.attachmentAddedListener = e -> this.onAttachmentAdded((AttachmentAddedEvent)e);
        eventBus.addListener(AttachmentAddedEvent.class, this.attachmentAddedListener);
        this.attachmentRemovedListener = e -> this.onAttachmentRemoved((AttachmentRemovedEvent)e);
        eventBus.addListener(AttachmentRemovedEvent.class, this.attachmentRemovedListener);
    }

    protected void method_25426() {
        super.method_25426();
    }

    public void method_37432() {
        super.method_37432();
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_1799 selectedStack = this.playerInventory.method_7391();
            if (!(selectedStack.method_7909() instanceof AttachmentHost)) {
                class_310.method_1551().method_1507(null);
            } else {
                AttachmentHighlightEvent event = this.attachmentEventQueue.peek();
                if (event != null && event.isExpired()) {
                    this.attachmentEventQueue.poll();
                }
            }
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        this.method_25420(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        guiGraphics.method_25291(BACKGROUND_TEXTURE, 0, 0, 1, 0.0f, 0.0f, this.field_22789, this.field_22790, this.field_22789, this.field_22790);
        RenderSystem.disableBlend();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.method_2380(guiGraphics, mouseX, mouseY);
        poseStack.method_22909();
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        class_1799 selectedItem = this.field_22787.field_1724.method_6047();
        if (selectedItem != null && selectedItem.method_7909() instanceof AttachmentHost) {
            class_2561 label = selectedItem.method_7909().method_7864(selectedItem);
            guiGraphics.method_27534(this.field_22793, label, 180, 15, 0xFFFF00);
        }
    }

    private void renderItemInHand(class_332 guiGraphics, int mouseX, int mouseY) {
        class_310 minecraft = class_310.method_1551();
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)(this.field_22789 / 2 + 5), (float)(this.field_22790 / 2 - 30), 180.0f);
        this.applyMouseInteractionTransforms(poseStack, mouseX, mouseY);
        float zoom = this.mouseInteractionHandler.getZoom();
        poseStack.method_22905(zoom, zoom, zoom);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
        poseStack.method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.method_22905(100.0f, 100.0f, 100.0f);
        Matrix4fStack modelStack = RenderSystem.getModelViewStack();
        modelStack.pushMatrix();
        modelStack.mul((Matrix4fc)poseStack.method_23760().method_23761());
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 buffer = guiGraphics.method_51450();
        class_1799 itemStack = minecraft.field_1724.method_6047();
        class_1087 model = minecraft.method_1480().method_4019(itemStack, MiscUtil.getLevel((class_1297)minecraft.field_1724), (class_1309)minecraft.field_1724, minecraft.field_1724.method_5628() + class_811.field_4318.ordinal());
        minecraft.method_1480().method_23179(itemStack, class_811.field_4318, false, new class_4587(), (class_4597)buffer, 0xF000F0, class_4608.field_21444, model);
        guiGraphics.method_51452();
        modelStack.popMatrix();
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    private void applyMouseInteractionTransforms(class_4587 poseStack, int mouseX, int mouseY) {
        float interactionOffsetX = (float)this.mouseInteractionHandler.getX() + (this.mouseInteractionHandler.isInteracting() && this.mouseInteractionHandler.isTranslating() ? (float)mouseX - this.mouseInteractionHandler.getMouseClickedX() : 0.0f);
        float interactionOffsetY = (float)this.mouseInteractionHandler.getY() + (this.mouseInteractionHandler.isInteracting() && this.mouseInteractionHandler.isTranslating() ? (float)mouseY - this.mouseInteractionHandler.getMouseClickedY() : 0.0f);
        poseStack.method_46416(interactionOffsetX, interactionOffsetY, 0.0f);
        float interactionPitch = this.mouseInteractionHandler.getRotationPitch() - (this.mouseInteractionHandler.isInteracting() && this.mouseInteractionHandler.isRotating() ? (float)mouseY - this.mouseInteractionHandler.getMouseClickedY() : 0.0f) - 30.0f;
        float interactionYaw = this.mouseInteractionHandler.getRotationYaw() + (this.mouseInteractionHandler.isInteracting() && this.mouseInteractionHandler.isRotating() ? (float)mouseX - this.mouseInteractionHandler.getMouseClickedX() : 0.0f) + 150.0f;
        poseStack.method_22907(new Quaternionf().rotationXYZ(interactionPitch * ((float)Math.PI / 180), interactionYaw * ((float)Math.PI / 180), 0.0f));
    }

    public String getSelectedAttachmentPath() {
        return this.selectedAttachmentPath;
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        AttachmentSlot attachmentSlot;
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 250.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = this.getLeft();
        int top = this.getTop();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25291(GUI_TEXTURES, left, top, 1000, 0.0f, 0.0f, 176, 90, 256, 256);
        int attLeft = this.field_2776 + 5;
        int attTop = this.field_2800 + 8;
        int slotTextureLeftOffset = 176;
        int unavailableSlotTextureTopOffset = 36;
        SimpleAttachmentContainer childContainer = null;
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof HierarchicalSlot) {
            HierarchicalSlot hSlot = (HierarchicalSlot)class_17352;
            this.selectedAttachmentPath = hSlot.getPath();
        }
        if ((class_17352 = this.field_2787) instanceof AttachmentSlot && (childContainer = (attachmentSlot = (AttachmentSlot)class_17352).getChildContainer()) != null) {
            int childContainerIndex = childContainer.getContainerIndex();
            poseStack.method_22903();
            int elementsCount = childContainer.getVirtualInventory().getElements().size();
            guiGraphics.method_49601(attLeft + childContainerIndex * 22 - 2, attTop - 2, 22, 24 + 18 * elementsCount, -1061093377);
            poseStack.method_22909();
        }
        SimpleAttachmentContainer[] attachmentContainers = this.menu.getAttachmentContainers();
        for (int i = 0; i < attachmentContainers.length; ++i) {
            SimpleAttachmentContainer attachmentContainer = attachmentContainers[i];
            int availableSlotTextureTopOffset = i == 0 ? 0 : 18;
            int containerStartIndex = SimpleAttachmentContainer.getContainerStartIndex(attachmentContainers, i);
            if (attachmentContainer.getVirtualInventory() == null || attachmentContainer.getVirtualInventory().getElements().isEmpty()) continue;
            if (this.menu.method_7611(containerStartIndex).method_7682()) {
                guiGraphics.method_25291(GUI_TEXTURES, attLeft + i * 22, attTop, 1000, (float)slotTextureLeftOffset, 54.0f, 18, 18, 256, 256);
            }
            for (int j = 1; j < attachmentContainer.method_5439(); ++j) {
                int adjustedSlotIndex = containerStartIndex + j;
                AttachmentSlot slot = (AttachmentSlot)this.menu.method_7611(adjustedSlotIndex);
                if (!slot.method_7682()) continue;
                int textureTopOffset = this.menu.method_34255() == null || this.menu.method_34255().method_7960() || slot.method_7680(this.menu.method_34255()) ? availableSlotTextureTopOffset : unavailableSlotTextureTopOffset;
                guiGraphics.method_25291(GUI_TEXTURES, attLeft + i * 22, attTop + this.headerBottomPadding + j * 18, 1000, (float)slotTextureLeftOffset, (float)textureTopOffset, 18, 18, 256, 256);
            }
        }
        poseStack.method_22909();
        poseStack.method_22903();
        this.renderItemInHand(guiGraphics, mouseX, mouseY);
        this.selectedAttachmentPath = null;
        poseStack.method_22909();
        RenderSystem.disableBlend();
        poseStack.method_46416(0.0f, 0.0f, 2000.0f);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.mouseInteractionHandler.onMouseScrolled(mouseX, mouseY, scrollY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.mouseInteractionHandler.onMouseButtonClicked(mouseX, mouseY, button) || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.mouseInteractionHandler.onMouseButtonReleased(mouseX, mouseY, button) || super.method_25406(mouseX, mouseY, button);
    }

    private int getLeft() {
        return (this.field_22789 - 176) / 2;
    }

    private int getTop() {
        return (this.field_22790 - 90) / 2 + 74;
    }

    private boolean isMouseInScreen(double mouseX, double mouseY) {
        boolean isMouseInInventory;
        int width = 176;
        int left = this.getLeft();
        int top = this.getTop();
        boolean bl = isMouseInInventory = mouseX >= (double)left && mouseX <= (double)(left + width) && mouseY >= (double)top && mouseY <= (double)(top + 90);
        if (isMouseInInventory) {
            return false;
        }
        int attLeft = this.field_2776 + 5;
        int attTop = this.field_2800 + 8;
        boolean isMouseInAttachmentContainer = false;
        SimpleAttachmentContainer[] attachmentContainers = this.menu.getAttachmentContainers();
        for (int i = 0; i < attachmentContainers.length; ++i) {
            SimpleAttachmentContainer attachmentContainer = attachmentContainers[i];
            int containerStartIndex = SimpleAttachmentContainer.getContainerStartIndex(attachmentContainers, i);
            if (attachmentContainer.getVirtualInventory() == null || attachmentContainer.getVirtualInventory().getElements().isEmpty()) continue;
            int slotLeft = attLeft + i * 22;
            int slotRight = slotLeft + 18 + 4;
            if (mouseX < (double)slotLeft || mouseX > (double)slotRight || mouseY < (double)attTop) continue;
            int yBottom = 0;
            for (int j = 1; j < attachmentContainer.method_5439(); ++j) {
                int adjustedSlotIndex = containerStartIndex + j;
                AttachmentSlot slot = (AttachmentSlot)this.menu.method_7611(adjustedSlotIndex);
                if (slot.method_7682()) continue;
                yBottom = attTop + this.headerBottomPadding + j * 18;
                break;
            }
            if (!(mouseY < (double)yBottom)) continue;
            isMouseInAttachmentContainer = true;
            break;
        }
        return !isMouseInAttachmentContainer;
    }

    public void method_25419() {
        this.selectedAttachmentPath = null;
        Platform.getInstance().getEventBus().removeListener(AttachmentAddedEvent.class, this.attachmentAddedListener);
        Platform.getInstance().getEventBus().removeListener(AttachmentRemovedEvent.class, this.attachmentRemovedListener);
        super.method_25419();
    }

    public void beforeRenderingSlot(class_332 guiGraphics, class_1735 slot) {
        if (slot instanceof AttachmentSlot) {
            return;
        }
        if (this.menu.getPlayerInventory().field_7545 == 9 - (this.menu.field_7761.size() - slot.field_7874)) {
            guiGraphics.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, 1348235500);
        }
        if (slot.field_7874 >= this.menu.getTotalAttachmentSlots() && this.mayPlaceAttachment(slot.method_7677())) {
            guiGraphics.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, -1605328816);
        }
    }

    private boolean mayPlaceAttachment(class_1799 attachmentStack) {
        if (attachmentStack.method_7960() || !(attachmentStack.method_7909() instanceof Attachment)) {
            return false;
        }
        SimpleAttachmentContainer[] attachmentContainers = this.menu.getAttachmentContainers();
        for (int i = 0; i < attachmentContainers.length; ++i) {
            SimpleAttachmentContainer attachmentContainer = attachmentContainers[i];
            int containerStartIndex = SimpleAttachmentContainer.getContainerStartIndex(attachmentContainers, i);
            if (attachmentContainer.getVirtualInventory() == null || attachmentContainer.getVirtualInventory().getElements().isEmpty()) continue;
            for (int j = 1; j < attachmentContainer.method_5439(); ++j) {
                int adjustedSlotIndex = containerStartIndex + j;
                AttachmentSlot slot = (AttachmentSlot)this.menu.method_7611(adjustedSlotIndex);
                if (!slot.method_7682() || !slot.method_7680(attachmentStack)) continue;
                return true;
            }
        }
        return false;
    }

    public Pair<class_1921, Vector4f> getRenderTypeOverride(class_1799 baseItemStack, class_1799 attachmentItemStack, String attachmentName, String attachmentPath) {
        class_2960 texture = class_2960.method_60655((String)"pointblank", (String)("textures/item/" + attachmentName + ".png"));
        AttachmentHighlightEvent attachmentHighlight = this.attachmentEventQueue.peek();
        if (attachmentHighlight != null && class_1799.method_7984((class_1799)attachmentItemStack, (class_1799)attachmentHighlight.attachmentStack)) {
            if (attachmentHighlight.isHighlighted()) {
                class_1921 renderType = class_1921.method_23026((class_2960)texture);
                return Pair.of((Object)renderType, (Object)COLOR_GREEN);
            }
            return null;
        }
        String selectedAttachmentPath = this.getSelectedAttachmentPath();
        if (Objects.equals(attachmentPath, selectedAttachmentPath)) {
            class_1921 renderType = class_1921.method_23026((class_2960)texture);
            return Pair.of((Object)renderType, (Object)COLOR_GREEN);
        }
        if (selectedAttachmentPath != null && selectedAttachmentPath.endsWith("/") && attachmentPath.startsWith(selectedAttachmentPath.substring(0, selectedAttachmentPath.length() - 1))) {
            class_1921 renderType = class_1921.method_23026((class_2960)texture);
            return Pair.of((Object)renderType, (Object)COLOR_GREEN);
        }
        return null;
    }

    public void onAttachmentAdded(AttachmentAddedEvent event) {
        class_1937 level = MiscUtil.getLevel((class_1297)event.getPlayer());
        if (level.field_9236) {
            if (this.field_22787.field_1755 != this) {
                return;
            }
            ClientUtil.getClientPlayer().method_5783(SoundRegistry.ATTACHMENT_ADDED.get(), 1.0f, 1.0f);
            this.attachmentEventQueue.add(new AttachmentHighlightEvent(System.currentTimeMillis(), 750L, event.getParentStack(), event.getAttachmentStack()));
        }
    }

    public void onAttachmentRemoved(AttachmentRemovedEvent event) {
        class_1937 level = MiscUtil.getLevel((class_1297)event.getPlayer());
        if (level.field_9236) {
            if (this.field_22787.field_1755 != this) {
                return;
            }
            ClientUtil.getClientPlayer().method_5783(SoundRegistry.ATTACHMENT_REMOVED.get(), 1.0f, 1.0f);
            this.attachmentEventQueue.add(new AttachmentHighlightEvent(System.currentTimeMillis(), 750L, event.getParentStack(), event.getAttachmentStack()));
        }
    }

    private static class AttachmentHighlightEvent {
        private long startTime;
        private long duration;
        private class_1799 parentStack;
        private class_1799 attachmentStack;
        private long blinkInterval;

        public AttachmentHighlightEvent(long startTime, long duration, class_1799 parentStack, class_1799 attachmentStack) {
            this.startTime = startTime;
            this.duration = duration;
            this.parentStack = parentStack;
            this.attachmentStack = attachmentStack;
            this.blinkInterval = 150L;
        }

        public boolean isHighlighted() {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            if (elapsedTime >= this.duration) {
                return false;
            }
            long k = elapsedTime / this.blinkInterval;
            return k % 2L == 0L;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() >= this.startTime + this.duration;
        }
    }
}

