/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkScreen;
import com.simibubi.create.content.redstone.displayLink.source.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.RedstonePowerDisplaySource;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.utility.AdventureUtil;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.fabric.EnvExecutor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_746;

public class DisplayLinkBlock
extends WrenchableDirectionalBlock
implements IBE<DisplayLinkBlockEntity> {
    public static final class_2746 POWERED = class_2741.field_12484;

    public DisplayLinkBlock(class_4970.class_2251 p_i48415_1_) {
        super(p_i48415_1_);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 placed = super.method_9605(context);
        placed = (class_2680)placed.method_11657((class_2769)field_10927, (Comparable)context.method_8038());
        return (class_2680)placed.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(this.shouldBePowered(placed, context.method_8045(), context.method_8037())));
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public static void notifyGatherers(class_1936 level, class_2338 pos) {
        DisplayLinkBlock.forEachAttachedGatherer(level, pos, DisplayLinkBlockEntity::tickSource);
    }

    public static <T extends DisplaySource> void sendToGatherers(class_1936 level, class_2338 pos, BiConsumer<DisplayLinkBlockEntity, T> callback, Class<T> type) {
        DisplayLinkBlock.forEachAttachedGatherer(level, pos, dgte -> {
            if (type.isInstance(dgte.activeSource)) {
                callback.accept((DisplayLinkBlockEntity)dgte, (Object)dgte.activeSource);
            }
        });
    }

    private static void forEachAttachedGatherer(class_1936 level, class_2338 pos, Consumer<DisplayLinkBlockEntity> callback) {
        for (class_2350 d : Iterate.directions) {
            class_2586 blockEntity;
            class_2338 offsetPos = pos.method_10093(d);
            class_2680 blockState = level.method_8320(offsetPos);
            if (!AllBlocks.DISPLAY_LINK.has(blockState) || !((blockEntity = level.method_8321(offsetPos)) instanceof DisplayLinkBlockEntity)) continue;
            DisplayLinkBlockEntity dlbe = (DisplayLinkBlockEntity)blockEntity;
            if (dlbe.activeSource == null || dlbe.getDirection() != d.method_10153()) continue;
            callback.accept(dlbe);
        }
    }

    public void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        if (worldIn.field_9236) {
            return;
        }
        if (fromPos.equals((Object)pos.method_10093(((class_2350)state.method_11654((class_2769)field_10927)).method_10153()))) {
            DisplayLinkBlock.sendToGatherers((class_1936)worldIn, fromPos, (dlte, p) -> dlte.tickSource(), RedstonePowerDisplaySource.class);
        }
        boolean powered = this.shouldBePowered(state, worldIn, pos);
        boolean previouslyPowered = (Boolean)state.method_11654((class_2769)POWERED);
        if (previouslyPowered != powered) {
            worldIn.method_8652(pos, (class_2680)state.method_28493((class_2769)POWERED), 2);
            if (!powered) {
                this.withBlockEntityDo((class_1922)worldIn, pos, DisplayLinkBlockEntity::onNoLongerPowered);
            }
        }
    }

    private boolean shouldBePowered(class_2680 state, class_1937 worldIn, class_2338 pos) {
        boolean powered = false;
        for (class_2350 d : Iterate.directions) {
            if (d.method_10153() == state.method_11654((class_2769)field_10927) || worldIn.method_49808(pos.method_10093(d), d) == 0) continue;
            powered = true;
            break;
        }
        return powered;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515((class_2689.class_2690<class_2248, class_2680>)builder.method_11667(new class_2769[]{POWERED}));
    }

    public class_1269 method_9534(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand, class_3965 pHit) {
        if (pPlayer == null || AdventureUtil.isAdventure(pPlayer)) {
            return class_1269.field_5811;
        }
        if (pPlayer.method_5715()) {
            return class_1269.field_5811;
        }
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.withBlockEntityDo((class_1922)pLevel, pPos, be -> this.displayScreen((DisplayLinkBlockEntity)be, pPlayer)));
        return class_1269.field_5812;
    }

    @Environment(value=EnvType.CLIENT)
    protected void displayScreen(DisplayLinkBlockEntity be, class_1657 player) {
        if (!(player instanceof class_746)) {
            return;
        }
        if (be.targetOffset.equals((Object)class_2338.field_10980)) {
            player.method_7353((class_2561)Lang.translateDirect("display_link.invalid", new Object[0]), true);
            return;
        }
        ScreenOpener.open(new DisplayLinkScreen(be));
    }

    public boolean method_9516(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_10 pType) {
        return false;
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.DATA_GATHERER.get((class_2350)pState.method_11654((class_2769)field_10927));
    }

    @Override
    public Class<DisplayLinkBlockEntity> getBlockEntityClass() {
        return DisplayLinkBlockEntity.class;
    }

    @Override
    public class_2591<? extends DisplayLinkBlockEntity> getBlockEntityType() {
        return (class_2591)AllBlockEntityTypes.DISPLAY_LINK.get();
    }
}

