/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics;

import com.simibubi.create.content.kinetics.BlockStressDefaults;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2960;

public class BlockStressValues {
    private static final Map<String, IStressValueProvider> PROVIDERS = new HashMap<String, IStressValueProvider>();

    public static void registerProvider(String namespace, IStressValueProvider provider) {
        PROVIDERS.put(namespace, provider);
    }

    @Nullable
    public static IStressValueProvider getProvider(String namespace) {
        return PROVIDERS.get(namespace);
    }

    @Nullable
    public static IStressValueProvider getProvider(class_2248 block) {
        return BlockStressValues.getProvider(RegisteredObjects.getKeyOrThrow(block).method_12836());
    }

    public static double getImpact(class_2248 block) {
        class_2960 blockId = RegisteredObjects.getKeyOrThrow(block);
        IStressValueProvider provider = BlockStressValues.getProvider(blockId.method_12836());
        if (provider != null) {
            return provider.getImpact(block);
        }
        Double defaultImpact = BlockStressDefaults.DEFAULT_IMPACTS.get(blockId);
        if (defaultImpact != null) {
            return defaultImpact;
        }
        return 0.0;
    }

    public static double getCapacity(class_2248 block) {
        class_2960 blockId = RegisteredObjects.getKeyOrThrow(block);
        IStressValueProvider provider = BlockStressValues.getProvider(blockId.method_12836());
        if (provider != null) {
            return provider.getCapacity(block);
        }
        Double defaultCapacity = BlockStressDefaults.DEFAULT_CAPACITIES.get(blockId);
        if (defaultCapacity != null) {
            return defaultCapacity;
        }
        return 0.0;
    }

    public static boolean hasImpact(class_2248 block) {
        class_2960 blockId = RegisteredObjects.getKeyOrThrow(block);
        IStressValueProvider provider = BlockStressValues.getProvider(blockId.method_12836());
        if (provider != null) {
            return provider.hasImpact(block);
        }
        return BlockStressDefaults.DEFAULT_IMPACTS.containsKey(blockId);
    }

    public static boolean hasCapacity(class_2248 block) {
        class_2960 blockId = RegisteredObjects.getKeyOrThrow(block);
        IStressValueProvider provider = BlockStressValues.getProvider(blockId.method_12836());
        if (provider != null) {
            return provider.hasCapacity(block);
        }
        return BlockStressDefaults.DEFAULT_CAPACITIES.containsKey(blockId);
    }

    @Nullable
    public static Couple<Integer> getGeneratedRPM(class_2248 block) {
        class_2960 blockId = RegisteredObjects.getKeyOrThrow(block);
        IStressValueProvider provider = BlockStressValues.getProvider(blockId.method_12836());
        if (provider != null) {
            return provider.getGeneratedRPM(block);
        }
        return null;
    }

    public static interface IStressValueProvider {
        public double getImpact(class_2248 var1);

        public double getCapacity(class_2248 var1);

        public boolean hasImpact(class_2248 var1);

        public boolean hasCapacity(class_2248 var1);

        @Nullable
        public Couple<Integer> getGeneratedRPM(class_2248 var1);
    }
}

