/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.util;

import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.Trajectory;
import com.vicmatskiv.pointblank.util.TrajectoryPhaseListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;

public class TopDownAttackTrajectory
implements Trajectory<Phase> {
    private static final Logger LOGGER = LogManager.getFormatterLogger((String)"pointblank");
    private static final double TIME_PER_TICK = 0.05;
    private static final double DEFAULT_CLIMB_ACCELERATION = 0.25;
    private static final double DEFAULT_SOFT_LAUNCH_CURVATURE = Math.toRadians(20.0);
    private static final double DEFAULT_SOFT_LAUNCH_SPEED = 10.0;
    private static final double MIN_CURVATURE_ANGLE = Math.toRadians(15.0);
    private static final double COS_45 = Math.cos(0.7853981633974483);
    private static final double MIN_ATTACK_ANGLE = Math.toRadians(30.0);
    private static final double SOFT_LAUNCH_DISTANCE = 5.0;
    private static final double MIN_DISTANCE_TO_TARGET_FOR_TOP_DOWN_ATTACK = 25.0;
    private static final class_243 UP = new class_243(0.0, 1.0, 0.0);
    private static final class_243 DOWN = new class_243(0.0, -1.0, 0.0);
    private class_243 targetPosition;
    private class_243 startToTargetNormalized;
    private double defaultSpeed;
    private double currentSpeed;
    private double remainingClimbSpeed;
    private double climbToDescendTurnSpeed;
    private int currentTick;
    private int climbTicks;
    private int descendTicks;
    private double climbToDescendCurvature;
    private class_243 climbVector;
    private class_243 endOfClimbPosition;
    private class_243 deltaMovement;
    private class_243 startOfTickPosition;
    private class_243 endOfTickPosition;
    private class_243 verticalRotationAxis;
    private Phase phase;
    private Runnable pendingCorrection;
    private double wouldBeLaunchOffset;
    private double startClimbHOffset;
    private double startClimbVOffset;
    private double softLaunchCurvature;
    private int softLaunchTicks;
    private int softLaunchTurnTicks;
    private int softLaunchTicksBeforeTurn;
    private double defaultSoftLaunchSpeed;
    private double softLaunchSpeedBeforeTurn;
    private double climbAcceleration = 0.25;
    private List<TrajectoryPhaseListener<Phase>> trajectoryPhaseListeners = new ArrayList<TrajectoryPhaseListener<Phase>>();

    public static TopDownAttackTrajectory createTrajectory(class_243 startPosition, class_243 targetPosition, double defaultSpeedBlocksPerSecond) {
        LOGGER.trace("Initializing trajectory");
        class_243 startToTarget = targetPosition.method_1020(startPosition);
        class_243 startToTargetNormalized = startToTarget.method_1029();
        class_243 wouldBeClimbStartPosition = startPosition.method_1019(startToTargetNormalized.method_1021(5.0));
        LOGGER.trace("Start of soft launch position: (%.5f, %.5f, %.5f)", (Object)startPosition.field_1352, (Object)startPosition.field_1351, (Object)startPosition.field_1350);
        LOGGER.trace("End of soft launch position: (%.5f, %.5f, %.5f)", (Object)wouldBeClimbStartPosition.field_1352, (Object)wouldBeClimbStartPosition.field_1351, (Object)wouldBeClimbStartPosition.field_1350);
        double climbToDescendCurvature = MIN_CURVATURE_ANGLE;
        double defaultSpeed = defaultSpeedBlocksPerSecond * 0.05;
        double climbToDescendTurnSpeed = defaultSpeed * 0.75;
        double distanceToTarget = startToTarget.method_1033();
        if (distanceToTarget < 25.0) {
            return null;
        }
        ClimbInfo climbInfo = TopDownAttackTrajectory.getClimbInfo(startToTarget, targetPosition, wouldBeClimbStartPosition, climbToDescendCurvature, climbToDescendTurnSpeed);
        if (climbInfo == null) {
            return null;
        }
        LOGGER.trace("Climb to descend curvature: %.3f\u00b0", (Object)Math.toDegrees(climbToDescendCurvature));
        LOGGER.trace("Target pos: (%.5f, %.5f, %.5f)", (Object)targetPosition.field_1352, (Object)targetPosition.field_1351, (Object)targetPosition.field_1350);
        class_243 normalizedClimbVector = climbInfo.climbVector.method_1029();
        LOGGER.trace("Original normalized climb vector: (%.3f, %.3f, %.3f)", (Object)normalizedClimbVector.field_1352, (Object)normalizedClimbVector.field_1351, (Object)normalizedClimbVector.field_1350);
        TopDownAttackTrajectory topDownAttackTrajectory = new TopDownAttackTrajectory();
        TopDownAttackTrajectory.initSoftLaunch(topDownAttackTrajectory, climbInfo);
        topDownAttackTrajectory.climbToDescendTurnSpeed = climbToDescendTurnSpeed;
        topDownAttackTrajectory.climbToDescendCurvature = climbToDescendCurvature;
        topDownAttackTrajectory.climbVector = climbInfo.climbVector;
        topDownAttackTrajectory.endOfClimbPosition = wouldBeClimbStartPosition.method_1019(climbInfo.climbVector);
        LOGGER.trace("Start of climb position: (%.5f, %.5f, %.5f)", (Object)wouldBeClimbStartPosition.field_1352, (Object)wouldBeClimbStartPosition.field_1351, (Object)wouldBeClimbStartPosition.field_1350);
        LOGGER.trace("End of climb position: (%.5f, %.5f, %.5f)", (Object)topDownAttackTrajectory.endOfClimbPosition.field_1352, (Object)topDownAttackTrajectory.endOfClimbPosition.field_1351, (Object)topDownAttackTrajectory.endOfClimbPosition.field_1350);
        topDownAttackTrajectory.setPhase(Phase.SOFT_LAUNCH);
        topDownAttackTrajectory.targetPosition = targetPosition;
        topDownAttackTrajectory.startToTargetNormalized = startToTargetNormalized;
        topDownAttackTrajectory.defaultSpeed = defaultSpeedBlocksPerSecond * 0.05;
        topDownAttackTrajectory.currentSpeed = defaultSpeed;
        topDownAttackTrajectory.startOfTickPosition = topDownAttackTrajectory.endOfTickPosition = startPosition;
        return topDownAttackTrajectory;
    }

    private static ClimbInfo getClimbInfo(class_243 startToTarget, class_243 targetPosition, class_243 wouldBeClimbStartPosition, double climbToDescendCurvature, double climbToDescendTurnSpeed) {
        double downSimilarity = startToTarget.method_1029().method_1026(DOWN);
        if (downSimilarity > Math.cos(Math.toDegrees(10.0))) {
            return null;
        }
        double radius = TopDownAttackTrajectory.getRadius(climbToDescendTurnSpeed, climbToDescendCurvature);
        LOGGER.trace("Radius: %.5f", (Object)radius);
        class_243 pivot = TopDownAttackTrajectory.getPivot(wouldBeClimbStartPosition, targetPosition, radius, 0.0);
        LOGGER.trace("Pivot: (%.5f, %.5f, %.5f)", (Object)pivot.field_1352, (Object)pivot.field_1351, (Object)pivot.field_1350);
        return TopDownAttackTrajectory.getClimbInfo(wouldBeClimbStartPosition, pivot, radius);
    }

    private static void initSoftLaunch(TopDownAttackTrajectory topDownAttackTrajectory, ClimbInfo climbInfo) {
        double adjustedCurvature;
        double softLaunchSpeed;
        double wouldBeLaunchOffset = 5.0;
        double defaultSoftLaunchCurvature = DEFAULT_SOFT_LAUNCH_CURVATURE;
        topDownAttackTrajectory.defaultSoftLaunchSpeed = softLaunchSpeed = 0.5;
        if (defaultSoftLaunchCurvature > climbInfo.launchAngle) {
            defaultSoftLaunchCurvature = climbInfo.launchAngle / 10.0;
        }
        if (Math.abs((adjustedCurvature = MiscUtil.adjustDivisor(climbInfo.launchAngle, defaultSoftLaunchCurvature)) - defaultSoftLaunchCurvature) > 1.0E-6) {
            LOGGER.trace("Adjusted phi to: %.3f\u00b0", (Object)Math.toDegrees(adjustedCurvature));
        }
        double softLaunchRadius = softLaunchSpeed * 0.5 / Math.sin(adjustedCurvature * 0.5);
        int n = (int)Math.round(climbInfo.launchAngle / adjustedCurvature);
        double dnm1 = 2.0 * softLaunchRadius * Math.sin(adjustedCurvature * (double)(n - 1) * 0.5);
        double turnPointDistanceOffset = dnm1 * 0.5 / Math.cos(adjustedCurvature * (double)n * 0.5);
        double distanceToTurn = wouldBeLaunchOffset - turnPointDistanceOffset;
        LOGGER.trace("phi: %.3f\u00b0, L: %.3f\u00b0", (Object)Math.toDegrees(adjustedCurvature), (Object)Math.toDegrees(climbInfo.launchAngle));
        double D = 2.0 * softLaunchRadius * Math.sin(adjustedCurvature * (double)n * 0.5);
        topDownAttackTrajectory.startClimbHOffset = D * Math.cos(adjustedCurvature * (double)(n + 1) * 0.5) + distanceToTurn;
        topDownAttackTrajectory.startClimbVOffset = D * Math.sin(adjustedCurvature * (double)(n + 1) * 0.5);
        LOGGER.trace("Start climb at hv offsets: (%.3f, %.3f)", (Object)topDownAttackTrajectory.startClimbHOffset, (Object)topDownAttackTrajectory.startClimbVOffset);
        topDownAttackTrajectory.softLaunchSpeedBeforeTurn = MiscUtil.adjustDivisor(distanceToTurn, softLaunchSpeed);
        topDownAttackTrajectory.softLaunchTicksBeforeTurn = (int)Math.round(distanceToTurn / softLaunchSpeed);
        LOGGER.trace("Ticks before turn: %d, Ticks to turn: %d, R: %.3f, speed: %.3f, speed before turn: %.3f, ", (Object)topDownAttackTrajectory.softLaunchTicksBeforeTurn, (Object)n, (Object)softLaunchRadius, (Object)topDownAttackTrajectory.defaultSoftLaunchSpeed, (Object)topDownAttackTrajectory.softLaunchSpeedBeforeTurn);
        LOGGER.trace("Would be launch offset: %.3f, Turn offset:  %.3f", (Object)topDownAttackTrajectory.wouldBeLaunchOffset, (Object)distanceToTurn);
        topDownAttackTrajectory.softLaunchTurnTicks = n;
        topDownAttackTrajectory.softLaunchCurvature = adjustedCurvature;
        topDownAttackTrajectory.softLaunchTicks = topDownAttackTrajectory.softLaunchTicksBeforeTurn + topDownAttackTrajectory.softLaunchTurnTicks;
        LOGGER.trace("Total soft launch ticks: %d", (Object)topDownAttackTrajectory.softLaunchTicks);
    }

    private TopDownAttackTrajectory() {
    }

    @Override
    public void addListener(TrajectoryPhaseListener<Phase> listener) {
        this.trajectoryPhaseListeners.add(listener);
    }

    public Phase getPhase() {
        return this.phase;
    }

    @Override
    public class_243 getStartOfTickPosition() {
        return this.startOfTickPosition;
    }

    @Override
    public class_243 getEndOfTickPosition() {
        return this.endOfTickPosition;
    }

    @Override
    public class_243 getDeltaMovement() {
        return this.deltaMovement;
    }

    @Override
    public boolean isCompleted() {
        return this.phase == Phase.COMPLETED;
    }

    @Override
    public void tick() {
        switch (this.phase) {
            case SOFT_LAUNCH: {
                this.tickSoftLaunch();
                break;
            }
            case CLIMB: {
                this.tickClimb();
                break;
            }
            case CLIMB_TO_DESCEND_TURN: {
                this.tickTurn();
                break;
            }
            case DESCEND: {
                this.tickDescend();
                break;
            }
        }
        this.startOfTickPosition = this.endOfTickPosition;
        this.endOfTickPosition = this.startOfTickPosition.method_1019(this.deltaMovement);
        if (this.phase != Phase.COMPLETED) {
            if (this.pendingCorrection != null) {
                this.pendingCorrection.run();
                this.pendingCorrection = null;
            }
            this.debugDeltaMovement();
        }
        LOGGER.trace("Tick #%d, phase: %s, start: (%.5f, %.5f, %.5f), end: (%.5f, %.5f, %.5f), mv (%.5f, %.5f, %.5f)\n", new Object[]{this.currentTick, this.phase, this.startOfTickPosition.field_1352, this.startOfTickPosition.field_1351, this.startOfTickPosition.field_1350, this.endOfTickPosition.field_1352, this.endOfTickPosition.field_1351, this.endOfTickPosition.field_1350, this.deltaMovement.field_1352, this.deltaMovement.field_1351, this.deltaMovement.field_1350});
        ++this.currentTick;
    }

    private void setPhase(Phase phase) {
        this.phase = phase;
        LOGGER.trace("Started phase: %s", (Object)phase);
        for (TrajectoryPhaseListener<Phase> trajectoryPhaseListener : this.trajectoryPhaseListeners) {
            trajectoryPhaseListener.onStartPhase(phase, this.endOfTickPosition);
        }
    }

    private void tickDescend() {
        --this.descendTicks;
        if (this.descendTicks < -5) {
            this.setPhase(Phase.COMPLETED);
            return;
        }
        if (this.currentSpeed < this.defaultSpeed) {
            this.currentSpeed += this.climbAcceleration;
        }
        if (this.checkTargetProximity()) {
            this.setPhase(Phase.COMPLETED);
            return;
        }
        class_243 currentToTarget = this.correctTrajectory();
        this.deltaMovement = currentToTarget.method_1021(this.currentSpeed);
    }

    private class_243 correctTrajectory() {
        class_243 currentToTarget = this.targetPosition.method_1020(this.endOfTickPosition).method_1029();
        double targetDirSimilarity = currentToTarget.method_1029().method_1026(this.deltaMovement.method_1029());
        LOGGER.trace("Trajectory similarity: %.3f", (Object)targetDirSimilarity);
        class_243 newHorizontalRotationAxis = currentToTarget.method_1036(DOWN);
        if (this.verticalRotationAxis != null) {
            double rotationAxisSimilarity = newHorizontalRotationAxis.method_1029().method_1026(this.verticalRotationAxis.method_1029());
            if (rotationAxisSimilarity > 0.0 && targetDirSimilarity < COS_45) {
                this.verticalRotationAxis = newHorizontalRotationAxis;
            }
        } else {
            this.verticalRotationAxis = newHorizontalRotationAxis;
        }
        double angleToTarget = Math.acos(targetDirSimilarity);
        double rotationAngle = Math.min(angleToTarget, this.climbToDescendCurvature);
        double rotationAngleDegrees = Math.toDegrees(rotationAngle);
        LOGGER.trace("Descend rotation angle degrees: %.3f", (Object)rotationAngleDegrees);
        Quaterniond rotation = new Quaterniond();
        rotation.rotateTo(this.deltaMovement.field_1352, this.deltaMovement.field_1351, this.deltaMovement.field_1350, currentToTarget.field_1352, currentToTarget.field_1351, currentToTarget.field_1350);
        rotation.slerp((Quaterniondc)rotation, rotationAngle / this.climbToDescendCurvature);
        Vector3d dm = new Vector3d(this.deltaMovement.field_1352, this.deltaMovement.field_1351, this.deltaMovement.field_1350);
        dm.rotate((Quaterniondc)rotation);
        return currentToTarget;
    }

    private boolean checkTargetProximity() {
        class_243 startOfTickToTarget = this.targetPosition.method_1020(this.startOfTickPosition);
        class_243 endOfTickToTarget = this.targetPosition.method_1020(this.endOfTickPosition);
        double magnitudeDeltaMovementSqr = this.deltaMovement.method_1027();
        if (startOfTickToTarget.method_1027() < magnitudeDeltaMovementSqr && endOfTickToTarget.method_1027() < magnitudeDeltaMovementSqr) {
            class_243 crossProduct = this.deltaMovement.method_1036(startOfTickToTarget);
            double distanceFromTargetToTrajectory = crossProduct.method_1033() / Math.sqrt(magnitudeDeltaMovementSqr);
            LOGGER.trace("Distance from trajectory to target: %.3f", (Object)distanceFromTargetToTrajectory);
            return distanceFromTargetToTrajectory < 0.5;
        }
        return false;
    }

    private void tickSoftLaunch() {
        if (this.softLaunchTicksBeforeTurn > 0) {
            LOGGER.trace("Soft launch ticks before turn left: %d", (Object)this.softLaunchTicksBeforeTurn);
            this.deltaMovement = this.startToTargetNormalized.method_1021(this.softLaunchSpeedBeforeTurn);
            --this.softLaunchTicksBeforeTurn;
        } else if (this.softLaunchTurnTicks > 0) {
            LOGGER.trace("Soft launch turn ticks before climb: %d", (Object)this.softLaunchTurnTicks);
            class_243 ndm = this.deltaMovement.method_1029();
            this.deltaMovement = ndm.method_1021(this.defaultSoftLaunchSpeed);
            class_243 right = this.startToTargetNormalized.method_1036(UP);
            Quaterniond rotation = new Quaterniond();
            LOGGER.trace("Rotating %.3f\u00b0", (Object)Math.toDegrees(this.softLaunchCurvature));
            rotation.rotateAxis(this.softLaunchCurvature, right.field_1352, right.field_1351, right.field_1350);
            Vector3d dm = new Vector3d(this.deltaMovement.field_1352, this.deltaMovement.field_1351, this.deltaMovement.field_1350);
            dm.rotate((Quaterniondc)rotation);
            this.deltaMovement = new class_243(dm.x, dm.y, dm.z);
            --this.softLaunchTurnTicks;
        } else {
            this.prepareClimb();
            this.tickClimb();
        }
    }

    private void tickClimb() {
        LOGGER.trace("Climb tick #%d, speed: %.3f", (Object)this.climbTicks, (Object)this.currentSpeed);
        this.deltaMovement = new class_243(this.climbVector.field_1352, this.climbVector.field_1351, this.climbVector.field_1350).method_1029().method_1021(this.currentSpeed);
        if (this.climbTicks-- <= 0) {
            this.prepareTurn();
            this.tickTurn();
        } else {
            this.currentSpeed = this.currentSpeed < this.defaultSpeed - this.climbAcceleration ? (this.currentSpeed += this.climbAcceleration) : this.remainingClimbSpeed;
        }
    }

    private void tickTurn() {
        this.currentSpeed = this.climbToDescendTurnSpeed;
        LOGGER.trace("Speed: %.3f", (Object)this.currentSpeed);
        class_243 currentToTarget = this.targetPosition.method_1020(this.startOfTickPosition);
        class_243 normalizedDeltaMovement = this.deltaMovement.method_1029();
        this.deltaMovement = normalizedDeltaMovement.method_1021(this.currentSpeed);
        double targetDirSimilarity = currentToTarget.method_1029().method_1026(normalizedDeltaMovement);
        double targetDirOffset = Math.acos(targetDirSimilarity);
        double targetDirOffsetDegrees = Math.toDegrees(targetDirOffset);
        LOGGER.trace("Target direction similarity: %.5f, degrees: %.5f", (Object)targetDirSimilarity, (Object)targetDirOffsetDegrees);
        double rotationAngle = this.climbToDescendCurvature;
        class_243 newHorizontalRotationAxis = currentToTarget.method_1036(DOWN);
        if (this.verticalRotationAxis != null) {
            double rotationAxisSimilarity = newHorizontalRotationAxis.method_1029().method_1026(this.verticalRotationAxis.method_1029());
            if (rotationAxisSimilarity > 0.0 && targetDirSimilarity < COS_45) {
                this.verticalRotationAxis = newHorizontalRotationAxis;
            }
        } else {
            this.verticalRotationAxis = newHorizontalRotationAxis;
        }
        LOGGER.trace("Right: (%.5f, %.5f, %.5f)", (Object)this.verticalRotationAxis.field_1352, (Object)this.verticalRotationAxis.field_1351, (Object)this.verticalRotationAxis.field_1350);
        if (targetDirOffsetDegrees < Math.toDegrees(this.climbToDescendCurvature)) {
            this.prepareDescend(this.verticalRotationAxis, targetDirOffset);
            this.tickDescend();
        } else {
            Quaterniond rotation = new Quaterniond();
            rotation.rotateAxis(rotationAngle, this.verticalRotationAxis.field_1352, this.verticalRotationAxis.field_1351, this.verticalRotationAxis.field_1350);
            Vector3d dm = new Vector3d(this.deltaMovement.field_1352, this.deltaMovement.field_1351, this.deltaMovement.field_1350);
            dm.rotate((Quaterniondc)rotation);
            this.deltaMovement = new class_243(dm.x, dm.y, dm.z);
        }
    }

    private void debugDeltaMovement() {
        class_243 directionToTarget = this.targetPosition.method_1020(this.startOfTickPosition).method_1029();
        LOGGER.trace("Direction to target: (%.3f, %.3f, %.3f)", (Object)directionToTarget.field_1352, (Object)directionToTarget.field_1351, (Object)directionToTarget.field_1350);
        class_243 directionToTargetRight = directionToTarget.method_1036(UP).method_1029();
        class_243 updatedRight = this.deltaMovement.method_1036(UP).method_1029();
        double horizontalAngleOffset = Math.toDegrees(Math.acos(updatedRight.method_1026(directionToTargetRight)));
        LOGGER.trace("Horizontal azimuth offset: %.3f\u00b0", (Object)horizontalAngleOffset);
    }

    @Override
    public void setTargetPosition(class_243 updatedTargetPosition) {
        if (updatedTargetPosition.method_1025(this.targetPosition) < 0.001) {
            return;
        }
        if (this.phase == Phase.SOFT_LAUNCH || this.phase == Phase.CLIMB_TO_DESCEND_TURN) {
            return;
        }
        this.pendingCorrection = () -> {
            class_243 newDirection;
            class_243 newRight;
            class_243 currentRight = this.deltaMovement.method_1036(UP).method_1029();
            double rightSimilarity = currentRight.method_1026(newRight = (newDirection = updatedTargetPosition.method_1020(this.endOfTickPosition)).method_1036(UP).method_1029());
            double angle = Math.acos(rightSimilarity < 0.0 ? -rightSimilarity : rightSimilarity);
            LOGGER.trace("Correction angle: %.3f, old right vector: (%.5f, %.5f, %.5f), new right vector: (%.5f, %.5f, %.5f)", (Object)Math.toDegrees(angle), (Object)currentRight.field_1352, (Object)currentRight.field_1351, (Object)currentRight.field_1350, (Object)newRight.field_1352, (Object)newRight.field_1351, (Object)newRight.field_1350);
            Quaterniond rotation = new Quaterniond();
            rotation.rotateAxis(angle, TopDownAttackTrajectory.UP.field_1352, TopDownAttackTrajectory.UP.field_1351, TopDownAttackTrajectory.UP.field_1350);
            Vector3d dm = new Vector3d(this.deltaMovement.field_1352, this.deltaMovement.field_1351, this.deltaMovement.field_1350);
            dm.rotate((Quaterniondc)rotation);
            class_243 updatedDeltaMovement = new class_243(dm.x, dm.y, dm.z);
            LOGGER.trace("Updated delta movement from (%.5f, %.5f, %.5f) to (%.5f, %.5f, %.5f), angle: %.3f\u00b0", (Object)this.deltaMovement.field_1352, (Object)this.deltaMovement.field_1351, (Object)this.deltaMovement.field_1350, (Object)updatedDeltaMovement.field_1352, (Object)updatedDeltaMovement.field_1351, (Object)updatedDeltaMovement.field_1350, (Object)Math.toDegrees(angle));
            this.deltaMovement = updatedDeltaMovement;
            this.targetPosition = updatedTargetPosition;
            this.debugDeltaMovement();
        };
    }

    private void prepareClimb() {
        this.climbVector = this.endOfClimbPosition.method_1020(this.endOfTickPosition);
        class_243 normalizedClimbVector = this.climbVector.method_1029();
        LOGGER.trace("Recomputed normalized climb vector: (%.3f, %.3f, %.3f)", (Object)normalizedClimbVector.field_1352, (Object)normalizedClimbVector.field_1351, (Object)normalizedClimbVector.field_1350);
        double climbDistanceBeforeTurn = this.climbVector.method_1033();
        this.climbAcceleration = MiscUtil.adjustDivisor(this.defaultSpeed - this.defaultSoftLaunchSpeed, this.climbAcceleration);
        int climbAccelerationTicks = (int)Math.round((this.defaultSpeed - this.defaultSoftLaunchSpeed) / this.climbAcceleration);
        double averageSpeed = (this.defaultSpeed + this.defaultSoftLaunchSpeed - this.climbAcceleration) * 0.5;
        double climbAccelerationDistance = averageSpeed * (double)climbAccelerationTicks;
        if (climbAccelerationDistance > climbDistanceBeforeTurn) {
            double tickD = (-this.defaultSoftLaunchSpeed + Math.sqrt(this.defaultSoftLaunchSpeed * this.defaultSoftLaunchSpeed + 2.0 * this.climbAcceleration * climbDistanceBeforeTurn)) / this.climbAcceleration;
            climbAccelerationTicks = (int)Math.round(tickD);
        }
        class_243 stopClimbAccelerationPos = this.endOfTickPosition.method_1019(this.climbVector.method_1029().method_1021(climbAccelerationDistance));
        LOGGER.trace("Climb acceleration distance: %.3f. Stop acceleration at: (%.3f, %.3f, %.3f)", (Object)climbAccelerationDistance, (Object)stopClimbAccelerationPos.field_1352, (Object)stopClimbAccelerationPos.field_1351, (Object)stopClimbAccelerationPos.field_1350);
        double remainingClimbDistance = climbDistanceBeforeTurn - climbAccelerationDistance;
        if (remainingClimbDistance > this.defaultSpeed) {
            this.remainingClimbSpeed = MiscUtil.adjustDivisor(remainingClimbDistance, this.defaultSpeed);
            int remainingClimbTicks = (int)Math.round(remainingClimbDistance / this.remainingClimbSpeed);
            this.climbTicks = climbAccelerationTicks + remainingClimbTicks;
        } else {
            this.climbTicks = climbAccelerationTicks;
            this.remainingClimbSpeed = this.defaultSpeed;
        }
        this.currentSpeed = this.defaultSoftLaunchSpeed;
        this.setPhase(Phase.CLIMB);
    }

    private void prepareTurn() {
        this.setPhase(Phase.CLIMB_TO_DESCEND_TURN);
    }

    private void prepareDescend(class_243 right, double targetDirAngle) {
        this.setPhase(Phase.DESCEND);
        class_243 targetDir = this.targetPosition.method_1020(this.endOfTickPosition);
        double distanceToTarget = targetDir.method_1033();
        this.currentSpeed = MiscUtil.adjustDivisor(distanceToTarget, this.currentSpeed);
        this.descendTicks = (int)Math.round(distanceToTarget / this.currentSpeed);
        LOGGER.trace("Ticks to target: %d", (Object)this.descendTicks);
        this.deltaMovement = targetDir.method_1029().method_1021(this.currentSpeed);
    }

    public static double getRadius(double segmentLength, double curvatureAngle) {
        return segmentLength * 0.5 / Math.sin(curvatureAngle * 0.5);
    }

    public static class_243 getHorizontalProjection(class_243 source, class_243 target) {
        class_243 sourceTargetDirection = target.method_1020(source);
        class_243 right = sourceTargetDirection.method_1036(UP);
        class_243 hp = UP.method_1036(right).method_1029();
        return hp;
    }

    public static class_243 getPivot(class_243 source, class_243 target, double radius, double offset) {
        double s = radius / Math.tan(MIN_ATTACK_ANGLE);
        double normalizedOffset = s * class_3532.method_15350((double)offset, (double)-1.0, (double)1.0);
        class_243 hp = TopDownAttackTrajectory.getHorizontalProjection(source, target);
        return target.method_1019(hp.method_1021(-s + normalizedOffset)).method_1019(UP.method_1021(radius));
    }

    public static ClimbInfo getClimbInfo(class_243 source, class_243 pivot, double radius) {
        class_243 sourceToPivot = pivot.method_1020(source);
        class_243 right = sourceToPivot.method_1036(UP);
        double alpha = -Math.asin(radius / sourceToPivot.method_1033());
        class_243 horizontalProjection = TopDownAttackTrajectory.getHorizontalProjection(source, pivot);
        double sourceToPivotAngle = Math.acos(sourceToPivot.method_1029().method_1026(horizontalProjection.method_1029()));
        double sourceToPivotAngleDeg = Math.toDegrees(sourceToPivotAngle);
        double launchAngle = Math.abs(sourceToPivotAngle) + Math.abs(alpha);
        if (launchAngle > 1.5707963267948966) {
            LOGGER.trace("Launch angle %.5f exceeds 90 degrees", (Object)Math.toDegrees(launchAngle));
            return null;
        }
        LOGGER.trace("Angle to offset sourcePivot: %.5f, source-pivot angle: %.5f", (Object)Math.toDegrees(alpha), (Object)sourceToPivotAngleDeg);
        Quaterniond rotation = new Quaterniond();
        rotation.rotateAxis(-alpha, right.field_1352, right.field_1351, right.field_1350);
        Vector3d v = new Vector3d(sourceToPivot.field_1352, sourceToPivot.field_1351, sourceToPivot.field_1350).rotate((Quaterniondc)rotation).mul(Math.cos(alpha));
        return new ClimbInfo(launchAngle, new class_243(v.x, v.y, v.z));
    }

    public record ClimbInfo(double launchAngle, class_243 climbVector) {
    }

    public static enum Phase {
        SOFT_LAUNCH,
        CLIMB,
        CLIMB_TO_DESCEND_TURN,
        DESCEND,
        COMPLETED;

    }
}

