/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.platform.fabric;

import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.platform.fabric.FabricPayload;
import com.vicmatskiv.pointblank.util.MiscUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_746;

public class FabricNetworkService
implements NetworkService {
    private final LinkedHashMap<Class<?>, C2SPacketInfo<?, ?>> c2sPacketRegistrations = new LinkedHashMap();
    private final LinkedHashMap<Class<?>, S2CPacketInfo<?, ?>> s2cPacketRegistrations = new LinkedHashMap();

    @Override
    public <M, B extends class_2540> void registerPacket(Class<M> packetClass, NetworkService.Direction direction, BiConsumer<M, class_2540> encoder, Function<class_2540, M> decoder, BiConsumer<M, NetworkService.MessageContext> handler) {
        PacketType[] typeHolder;
        PacketType type = PacketType.create((class_2960)new class_2960("pointblank", packetClass.getSimpleName().toLowerCase()), buf -> new FabricPayload(typeHolder[0], decoder.apply((class_2540)buf), encoder));
        typeHolder = new PacketType[]{type};
        if (direction == NetworkService.Direction.SERVER_TO_CLIENT) {
            this.addS2CRegistration(packetClass, encoder, decoder, handler, (PacketType<FabricPacket>)type);
        } else {
            this.addC2SRegistration(packetClass, encoder, decoder, handler, (PacketType<FabricPacket>)type);
        }
    }

    private <M> void addC2SRegistration(Class<M> packetClass, BiConsumer<M, class_2540> encoder, Function<class_2540, M> decoder, BiConsumer<M, NetworkService.MessageContext> handler, PacketType<FabricPacket> type) {
        this.c2sPacketRegistrations.put(packetClass, new C2SPacketInfo<M, FabricPacket>(packetClass, type, encoder, decoder, handler));
    }

    private <M> void addS2CRegistration(Class<M> packetClass, BiConsumer<M, class_2540> encoder, Function<class_2540, M> decoder, BiConsumer<M, NetworkService.MessageContext> handler, PacketType<FabricPacket> type) {
        this.s2cPacketRegistrations.put(packetClass, new S2CPacketInfo<M, FabricPacket>(packetClass, type, encoder, decoder, handler));
    }

    @Override
    public void onRegisteringPacketsCompleted() {
        for (Map.Entry<Class<?>, C2SPacketInfo<?, ?>> entry : this.c2sPacketRegistrations.entrySet()) {
            C2SPacketInfo<?, ?> packetInfo = entry.getValue();
            this.registerClientPacketReceiver(packetInfo);
        }
    }

    @Override
    public void onRegisteringClientPacketsCompleted() {
        for (Map.Entry<Class<?>, S2CPacketInfo<?, ?>> entry : this.s2cPacketRegistrations.entrySet()) {
            S2CPacketInfo<?, ?> packetInfo = entry.getValue();
            this.registerServerPacketReceiver(packetInfo);
        }
    }

    private <M, T extends FabricPacket> void registerServerPacketReceiver(S2CPacketInfo<M, T> packetInfo) {
        ClientPlayNetworking.registerGlobalReceiver(packetInfo.type, (ClientPlayNetworking.PlayPacketHandler)((ClientPlayNetworking.PlayPacketHandler)packetInfo.getHandler()));
    }

    private <M, T extends FabricPacket> void registerClientPacketReceiver(C2SPacketInfo<M, T> packetInfo) {
        ServerPlayNetworking.registerGlobalReceiver(packetInfo.type, packetInfo.getHandler());
    }

    @Override
    public void sendToClient(Object message, class_1657 toPlayer) {
        S2CPacketInfo<?, ?> info = this.s2cPacketRegistrations.get(message.getClass());
        ServerPlayNetworking.send((class_3222)((class_3222)toPlayer), info.createPayload(message));
    }

    @Override
    public void sendToServer(Object message) {
        C2SPacketInfo<?, ?> info = this.c2sPacketRegistrations.get(message.getClass());
        ClientPlayNetworking.send(info.createPayload(message));
    }

    private record C2SPacketInfo<M, T extends FabricPacket>(Class<M> packetClass, PacketType<T> type, BiConsumer<M, class_2540> encoder, Function<class_2540, M> decoder, BiConsumer<M, NetworkService.MessageContext> handler) {
        public ServerPlayNetworking.PlayPacketHandler<T> getHandler() {
            return (packet, player, responseSender) -> this.handler.accept(this.packetClass.cast(((FabricPayload)packet).getData()), new FabricC2SMessageContext(player));
        }

        public FabricPayload<M> createPayload(Object message) {
            return new FabricPayload<M>(this.type, this.packetClass.cast(message), this.encoder);
        }
    }

    private record S2CPacketInfo<M, T extends FabricPacket>(Class<M> packetClass, PacketType<T> type, BiConsumer<M, class_2540> encoder, Function<class_2540, M> decoder, BiConsumer<M, NetworkService.MessageContext> handler) {
        public Object getHandler() {
            return new ClientPlayNetworking.PlayPacketHandler<T>(){

                public void receive(T packet, class_746 player, PacketSender responseSender) {
                    handler.accept(packetClass.cast(((FabricPayload)packet).getData()), new FabricS2CMessageContext((class_1657)player));
                }
            };
        }

        public FabricPayload<M> createPayload(Object message) {
            return new FabricPayload<M>(this.type, this.packetClass.cast(message), this.encoder);
        }
    }

    static class FabricC2SMessageContext
    implements NetworkService.MessageContext {
        private final class_3222 serverPlayer;

        FabricC2SMessageContext(class_3222 serverPlayer) {
            this.serverPlayer = serverPlayer;
        }

        @Override
        public void enqueueWork(Runnable runnable) {
            this.serverPlayer.method_5682().execute(runnable);
        }

        @Override
        public void setPacketHandled(boolean isPacketHandled) {
        }

        @Override
        public class_1657 getSender() {
            return this.serverPlayer;
        }

        @Override
        public boolean isClientSide() {
            return MiscUtil.isClientSide((class_1297)this.serverPlayer);
        }
    }

    public static class FabricS2CMessageContext
    implements NetworkService.MessageContext {
        private final class_1657 player;

        public FabricS2CMessageContext(class_1657 player) {
            this.player = player;
        }

        @Override
        public void enqueueWork(Runnable runnable) {
            class_310 client = class_310.method_1551();
            client.execute(runnable);
        }

        @Override
        public void setPacketHandled(boolean isPacketHandled) {
        }

        @Override
        public class_1657 getSender() {
            return this.player;
        }

        @Override
        public boolean isClientSide() {
            return MiscUtil.isClientSide((class_1297)this.player);
        }
    }
}

