/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.network;

import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.feature.Feature;
import com.vicmatskiv.pointblank.registry.FeatureTypeRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class ServerBoundNextAttachmentPacket {
    private AttachmentCategory category;
    private Class<? extends Feature> featureType;

    public ServerBoundNextAttachmentPacket(AttachmentCategory category, Class<? extends Feature> featureType) {
        this.category = category;
        this.featureType = featureType;
    }

    public ServerBoundNextAttachmentPacket() {
    }

    public static void encode(ServerBoundNextAttachmentPacket packet, class_2540 buf) {
        buf.writeInt(packet.category.ordinal());
        buf.writeInt(FeatureTypeRegistry.getFeatureTypeId(packet.featureType));
    }

    public static ServerBoundNextAttachmentPacket decode(class_2540 buf) {
        return new ServerBoundNextAttachmentPacket(AttachmentCategory.fromOrdinal(buf.readInt()), FeatureTypeRegistry.getFeatureType(buf.readInt()));
    }

    public static void handle(ServerBoundNextAttachmentPacket packet, NetworkService.MessageContext ctx) {
        ctx.enqueueWork(() -> {
            class_3222 player = (class_3222)ctx.getSender();
            class_1799 mainHeldItem = player.method_6047();
            if (mainHeldItem != null) {
                Attachments.selectNextAttachment(mainHeldItem, packet.category, packet.featureType);
            }
        });
        ctx.setPacketHandled(true);
    }
}

