/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.network;

import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.client.ClientEventHandler;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.InventoryUtils;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3545;

public class GunStateResponsePacket {
    protected UUID stateId;
    protected int slotIndex;
    protected int correlationId;
    protected boolean isSuccess;

    public GunStateResponsePacket() {
    }

    public GunStateResponsePacket(UUID stateId, int slotIndex, int correlationId, boolean isSuccess) {
        this.stateId = stateId;
        this.slotIndex = slotIndex;
        this.correlationId = correlationId;
        this.isSuccess = isSuccess;
    }

    public static <T extends GunStateResponsePacket> void encode(T packet, class_2540 buffer) {
        buffer.writeLong(packet.stateId.getMostSignificantBits());
        buffer.writeLong(packet.stateId.getLeastSignificantBits());
        buffer.writeInt(packet.slotIndex);
        buffer.writeInt(packet.correlationId);
        buffer.writeBoolean(packet.isSuccess);
        packet.doEncode(buffer);
    }

    protected void doEncode(class_2540 buffer) {
    }

    protected static GunStateResponsePacket decodeHeader(class_2540 buffer) {
        UUID stateId = new UUID(buffer.readLong(), buffer.readLong());
        int slotIndex = buffer.readInt();
        int correlationId = buffer.readInt();
        boolean isSuccess = buffer.readBoolean();
        return new GunStateResponsePacket(stateId, slotIndex, correlationId, isSuccess);
    }

    public static <T extends GunStateResponsePacket> void handle(T packet, NetworkService.MessageContext ctx) {
        ctx.enqueueWork(() -> {
            class_1657 player = ClientUtil.getClientPlayer();
            ClientEventHandler.runSyncTick(() -> {
                class_3545<class_1799, GunClientState> targetTuple = packet.getItemStackAndState(packet, (class_1297)player);
                if (targetTuple != null) {
                    packet.handleEnqueued(ctx, (class_1799)targetTuple.method_15442(), (GunClientState)targetTuple.method_15441());
                }
            });
        });
        ctx.setPacketHandled(true);
    }

    protected <T extends GunStateResponsePacket> class_3545<class_1799, GunClientState> getItemStackAndState(T packet, class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return InventoryUtils.getItemStackByStateId(player, packet.stateId, packet.slotIndex);
        }
        return null;
    }

    protected <T extends GunStateResponsePacket> void handleEnqueued(NetworkService.MessageContext ctx, class_1799 itemStack, GunClientState gunClientState) {
    }
}

