/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.network;

import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.network.EffectBroadcastPacket;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.SimpleHitResult;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectRequestPacket {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static final int MAX_DISTANCE_SQR = 22500;
    protected int playerEntityId;
    protected UUID gunStateId;
    protected UUID effectId;
    protected class_243 startPosition;
    protected SimpleHitResult hitResult;
    protected boolean hasMuzzlePositionProvider;

    public EffectRequestPacket() {
    }

    public EffectRequestPacket(int playerEntityId, UUID gunStateId, UUID effectId, class_243 startPosition, SimpleHitResult hitResult, boolean hasMuzzlePositionProvider) {
        this.playerEntityId = playerEntityId;
        this.gunStateId = gunStateId;
        this.effectId = effectId;
        this.startPosition = startPosition;
        this.hitResult = hitResult;
        this.hasMuzzlePositionProvider = hasMuzzlePositionProvider;
    }

    public static <T extends EffectRequestPacket> void encode(T packet, class_2540 buffer) {
        buffer.writeInt(packet.playerEntityId);
        buffer.writeLong(packet.gunStateId.getMostSignificantBits());
        buffer.writeLong(packet.gunStateId.getLeastSignificantBits());
        buffer.writeLong(packet.effectId.getMostSignificantBits());
        buffer.writeLong(packet.effectId.getLeastSignificantBits());
        buffer.method_37435(Optional.ofNullable(packet.startPosition), MiscUtil.VEC3_WRITER);
        buffer.method_37435(Optional.ofNullable(packet.hitResult), SimpleHitResult.writer());
        buffer.writeBoolean(packet.hasMuzzlePositionProvider);
        packet.doEncode(buffer);
    }

    protected void doEncode(class_2540 buffer) {
    }

    protected static EffectRequestPacket decode(class_2540 buffer) {
        int playerEntityId = buffer.readInt();
        UUID gunStateId = new UUID(buffer.readLong(), buffer.readLong());
        UUID effectId = new UUID(buffer.readLong(), buffer.readLong());
        class_243 startPosition = buffer.method_37436(MiscUtil.VEC3_READER).orElse(null);
        SimpleHitResult hitResult = buffer.method_37436(SimpleHitResult.reader()).orElse(null);
        boolean hasMuzzlePositionProvider = buffer.readBoolean();
        return new EffectRequestPacket(playerEntityId, gunStateId, effectId, startPosition, hitResult, hasMuzzlePositionProvider);
    }

    public static <T extends EffectRequestPacket> void handle(T packet, NetworkService.MessageContext ctx) {
        ctx.enqueueWork(() -> packet.handleEnqueued(ctx));
        ctx.setPacketHandled(true);
    }

    protected <T extends EffectRequestPacket> void handleEnqueued(NetworkService.MessageContext ctx) {
        class_3222 sender = (class_3222)ctx.getSender();
        LOGGER.debug("Received effect request {} from {}", (Object)this, (Object)sender);
        for (class_3222 player : ((class_3218)MiscUtil.getLevel((class_1297)sender)).method_18766(p -> true)) {
            if (!(player.method_5707(this.startPosition) < 22500.0)) continue;
            Platform.getInstance().getNetworkService().sendToClient(new EffectBroadcastPacket(this.playerEntityId, this.gunStateId, this.effectId, this.startPosition, this.hitResult, this.hasMuzzlePositionProvider), (class_1657)player);
        }
    }
}

