/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.network;

import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.network.GunStateRequestPacket;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AimingChangeRequestPacket
extends GunStateRequestPacket {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private boolean isAimingEnabled;

    public AimingChangeRequestPacket() {
    }

    public AimingChangeRequestPacket(UUID stateId, int slotIndex, boolean isAimingEnabled) {
        super(stateId, slotIndex);
        this.isAimingEnabled = isAimingEnabled;
    }

    public static AimingChangeRequestPacket decode(class_2540 buffer) {
        GunStateRequestPacket header = GunStateRequestPacket.decodeHeader(buffer);
        return new AimingChangeRequestPacket(header.stateId, header.slotIndex, buffer.readBoolean());
    }

    @Override
    protected void doEncode(class_2540 buffer) {
        buffer.writeBoolean(this.isAimingEnabled);
    }

    @Override
    protected <T extends GunStateRequestPacket> void handleEnqueued(NetworkService.MessageContext ctx) {
        class_3222 player = (class_3222)ctx.getSender();
        if (player != null) {
            class_1792 class_17922;
            class_1799 itemStack = player.method_31548().method_5438(this.slotIndex);
            if (itemStack != null && (class_17922 = itemStack.method_7909()) instanceof GunItem) {
                GunItem gunItem = (GunItem)class_17922;
                gunItem.handleAimingChangeRequest((class_1657)player, itemStack, this.stateId, this.slotIndex, this.isAimingEnabled);
            } else {
                LOGGER.warn("Mismatching item in slot {}", (Object)this.slotIndex);
            }
        }
    }
}

