/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.item;

import com.google.gson.JsonObject;
import com.vicmatskiv.pointblank.Nameable;
import com.vicmatskiv.pointblank.client.render.DefaultModelRenderer;
import com.vicmatskiv.pointblank.item.ItemBuilder;
import com.vicmatskiv.pointblank.util.JsonUtil;
import com.vicmatskiv.pointblank.util.Tradeable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_756;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MiscItem
extends class_1792
implements Nameable,
Tradeable {
    private String name;
    private float tradePrice;
    private int tradeBundleQuantity;
    private int tradeLevel;

    public MiscItem(String name, float tradePrice, int tradeBundleQuantity, int tradeLevel) {
        super(new class_1792.class_1793());
        this.name = name;
        this.tradePrice = tradePrice;
        this.tradeLevel = tradeLevel;
        this.tradeBundleQuantity = tradeBundleQuantity;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getPrice() {
        return this.tradePrice;
    }

    @Override
    public int getTradeLevel() {
        return this.tradeLevel;
    }

    @Override
    public int getBundleQuantity() {
        return this.tradeBundleQuantity;
    }

    private static class MiscModelItem
    extends MiscItem
    implements GeoItem {
        private Supplier<Object> rendererSupplier;
        private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
        private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

        public MiscModelItem(String name, Supplier<Object> rendererSupplier, float tradePrice, int tradeBundleQuantity, int tradeLevel) {
            super(name, tradePrice, tradeBundleQuantity, tradeLevel);
            this.rendererSupplier = rendererSupplier;
        }

        public void registerControllers(AnimatableManager.ControllerRegistrar registry) {
        }

        public AnimatableInstanceCache getAnimatableInstanceCache() {
            return this.cache;
        }

        public void createRenderer(Consumer<Object> consumer) {
            consumer.accept(new RenderProvider(){
                private class_756 renderer;

                public class_756 getCustomRenderer() {
                    if (this.renderer == null) {
                        this.renderer = (class_756)rendererSupplier.get();
                    }
                    return this.renderer;
                }
            });
        }

        public Supplier<Object> getRenderProvider() {
            return this.renderProvider;
        }
    }

    public static class MiscItemBuilder
    extends ItemBuilder<MiscItemBuilder>
    implements Nameable {
        private static final float DEFAULT_PRICE = Float.NaN;
        private static final int DEFAULT_TRADE_LEVEL = 0;
        private static final int DEFAULT_TRADE_BUNDLE_QUANTITY = 1;
        private String name;
        private Supplier<Object> rendererBuilder;
        private float tradePrice = Float.NaN;
        private int tradeBundleQuantity = 1;
        private int tradeLevel = 0;

        public MiscItemBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public MiscItemBuilder withRenderer(Supplier<Object> rendererBuilder) {
            this.rendererBuilder = rendererBuilder;
            return this;
        }

        public MiscItemBuilder withTradePrice(double price, int tradeBundleQuantity, int tradeLevel) {
            this.tradePrice = (float)price;
            this.tradeLevel = tradeLevel;
            this.tradeBundleQuantity = tradeBundleQuantity;
            return this;
        }

        public MiscItemBuilder withTradePrice(double price, int tradeLevel) {
            return this.withTradePrice(price, 1, tradeLevel);
        }

        @Override
        public MiscItemBuilder withJsonObject(JsonObject obj, boolean isClientSide) {
            String rendererType;
            this.withName(JsonUtil.getJsonString(obj, "name"));
            this.withTradePrice(JsonUtil.getJsonFloat(obj, "tradePrice", Float.NaN), JsonUtil.getJsonInt(obj, "traceBundleQuantity", 1), JsonUtil.getJsonInt(obj, "tradeLevel", 0));
            JsonObject rendererObj = obj.getAsJsonObject("renderer");
            if (isClientSide && rendererObj != null && (rendererType = JsonUtil.getJsonString(rendererObj, "type")).toLowerCase().equals("model")) {
                this.withRenderer(() -> new DefaultModelRenderer(this.name));
            }
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public class_1792 build() {
            if (this.rendererBuilder != null) {
                return new MiscModelItem(this.name, this.rendererBuilder, this.tradePrice, this.tradeBundleQuantity, this.tradeLevel);
            }
            return new MiscItem(this.name, this.tradePrice, this.tradeBundleQuantity, this.tradeLevel);
        }
    }
}

