/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.inventory;

import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.AttachmentHost;
import com.vicmatskiv.pointblank.event.MenuRegistry;
import com.vicmatskiv.pointblank.inventory.Activatable;
import com.vicmatskiv.pointblank.inventory.AttachmentHeadingSlot;
import com.vicmatskiv.pointblank.inventory.AttachmentSlot;
import com.vicmatskiv.pointblank.inventory.HierarchicalSlot;
import com.vicmatskiv.pointblank.inventory.SimpleAttachmentContainer;
import com.vicmatskiv.pointblank.inventory.SlotMapping;
import com.vicmatskiv.pointblank.inventory.VirtualInventory;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttachmentContainerMenu
extends class_1703 {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static final int MAX_TOP_LEVEL_ATTACHMENTS = 11;
    private static final int ATTACHMENT_CONTAINERS = 10;
    private static final int ATTACHMENTS_PER_CONTAINER = 6;
    private SlotMapping slotMapping;
    private class_1661 playerInventory;
    private VirtualInventory virtualInventory;
    private SimpleAttachmentContainer[] attachmentContainers;
    private int totalAttachmentSlots;
    private int slotWidth;
    private int slotHeight;
    private int mainInventoryLeftOffset;
    private int mainInventoryTopOffset;
    private int hotBarTopOffset;
    private int attachmentsLeftOffset;
    private int attachmentsTopOffset;
    private int attachmentsSlotRightPadding;
    private int attachmentsHeaderBottomPadding;

    public AttachmentContainerMenu(int containerId, class_1661 playerInventory) {
        this(containerId, playerInventory, playerInventory.method_7391());
    }

    public AttachmentContainerMenu(int containerId, class_1661 playerInventory, class_1799 itemStack) {
        super(MenuRegistry.ATTACHMENTS.get(), containerId);
        AttachmentHost attachmentHost = (AttachmentHost)itemStack.method_7909();
        this.slotWidth = 18;
        this.slotHeight = 18;
        this.hotBarTopOffset = 220;
        this.mainInventoryLeftOffset = 105;
        this.mainInventoryTopOffset = 162;
        this.attachmentsSlotRightPadding = 4;
        this.attachmentsHeaderBottomPadding = 2;
        this.attachmentsLeftOffset = 6;
        this.attachmentsTopOffset = 9;
        this.playerInventory = playerInventory;
        this.slotMapping = SlotMapping.getOrCreate(playerInventory.field_7546);
        this.virtualInventory = VirtualInventory.createInventory(playerInventory.field_7546, playerInventory.method_7391());
        this.attachmentContainers = new SimpleAttachmentContainer[10];
        this.totalAttachmentSlots = Math.min(attachmentHost.getMaxAttachmentCategories(), 11) + 63;
        try {
            this.initAttachmentContainers();
            this.updateAttachmentSlots();
            this.addInventorySlots();
            this.addHotbarSlots();
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize attachment container menu", (Throwable)e);
        }
    }

    public class_1661 getPlayerInventory() {
        return this.playerInventory;
    }

    public SimpleAttachmentContainer[] getAttachmentContainers() {
        return this.attachmentContainers;
    }

    public int getTotalAttachmentSlots() {
        return this.totalAttachmentSlots;
    }

    private void addInventorySlots() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)this.playerInventory, j + i * 9 + 9, this.mainInventoryLeftOffset + j * this.slotWidth, this.mainInventoryTopOffset + i * this.slotHeight));
            }
        }
    }

    private void addHotbarSlots() {
        for (int i = 0; i < 9; ++i) {
            if (i == this.playerInventory.field_7545) {
                this.method_7621(new class_1735((class_1263)this.playerInventory, i, this.mainInventoryLeftOffset + i * this.slotWidth, this.hotBarTopOffset){

                    public boolean method_7674(class_1657 playerIn) {
                        return false;
                    }
                });
                continue;
            }
            this.method_7621(new class_1735((class_1263)this.playerInventory, i, this.mainInventoryLeftOffset + i * this.slotWidth, this.hotBarTopOffset));
        }
    }

    private void initAttachmentContainers() {
        for (int containerIndex = 0; containerIndex < 10; ++containerIndex) {
            this.attachmentContainers[containerIndex] = this.initAttachmentContainer(containerIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleAttachmentContainer initAttachmentContainer(int containerIndex) {
        int attachmentSlotCount = containerIndex == 0 ? 11 : 6;
        SimpleAttachmentContainer attachmentContainer = new SimpleAttachmentContainer(containerIndex, this, attachmentSlotCount + 1);
        LOGGER.debug("Created container {}", (Object)containerIndex);
        AttachmentHeadingSlot attachmentHeadingSlot = new AttachmentHeadingSlot(attachmentContainer, 0, this.attachmentsLeftOffset + containerIndex * (this.slotWidth + this.attachmentsSlotRightPadding), this.attachmentsTopOffset, attachmentContainer);
        this.method_34256();
        try {
            this.method_7621(attachmentHeadingSlot);
            for (int attachmentInContainerIndex = 1; attachmentInContainerIndex < attachmentSlotCount + 1; ++attachmentInContainerIndex) {
                AttachmentSlot attachmentSlot = new AttachmentSlot(this.playerInventory.field_7546, this, attachmentContainer, attachmentInContainerIndex, this.attachmentsLeftOffset + containerIndex * (this.slotWidth + this.attachmentsSlotRightPadding), this.attachmentsTopOffset + this.attachmentsHeaderBottomPadding + attachmentInContainerIndex * this.slotHeight);
                attachmentSlot.setActive(false);
                this.method_7621(attachmentSlot);
                LOGGER.debug("Added attachment slot {} to container {}", (Object)attachmentInContainerIndex, (Object)attachmentContainer);
            }
        }
        finally {
            this.method_34257();
        }
        return attachmentContainer;
    }

    private void clearContainer(int i, SimpleAttachmentContainer container) {
        container.setParentContainer(container);
        container.removeAllListeners();
        container.method_5448();
        container.setVirtualInventory(null);
        int startSlotIndex = SimpleAttachmentContainer.getContainerStartIndex(this.attachmentContainers, i);
        for (int attachmentSlotIndex = 1; attachmentSlotIndex < container.method_5439(); ++attachmentSlotIndex) {
            int absoluteSlotIndex = startSlotIndex + attachmentSlotIndex;
            ((Activatable)this.method_7611(absoluteSlotIndex)).setActive(false);
        }
    }

    void updateAttachmentSlots() {
        this.method_34256();
        try {
            int lastContainerIndex = this.updateAttachmentSlots(null, null, this.virtualInventory, 0);
            for (int i = lastContainerIndex + 1; i < this.attachmentContainers.length; ++i) {
                this.clearContainer(i, this.attachmentContainers[i]);
            }
        }
        finally {
            this.method_34257();
        }
    }

    private int updateAttachmentSlots(AttachmentSlot parentSlot, SimpleAttachmentContainer parentContainer, VirtualInventory virtualInventory, int containerIndex) {
        if (virtualInventory == null) {
            return -1;
        }
        if (containerIndex >= this.attachmentContainers.length) {
            LOGGER.error("Requested container index {} exceeds the max {}", (Object)containerIndex, (Object)(this.attachmentContainers.length - 1));
            return -1;
        }
        int maxContainerIndex = containerIndex;
        SimpleAttachmentContainer container = this.attachmentContainers[containerIndex];
        container.removeAllListeners();
        container.method_5448();
        container.setVirtualInventory(virtualInventory);
        container.setParentContainer(parentContainer);
        if (parentSlot != null) {
            parentSlot.setChildContainer(container);
        }
        LOGGER.debug("Updating attachment slots for inventory {} for container {}", (Object)virtualInventory, (Object)containerIndex);
        Map<Integer, AttachmentCategory> mapping = this.slotMapping.getOrCreateSlotMapping(virtualInventory);
        int startSlotIndex = SimpleAttachmentContainer.getContainerStartIndex(this.attachmentContainers, containerIndex);
        class_1799 headerStack = virtualInventory.getItemStack().method_7972();
        container.method_5447(0, headerStack);
        HierarchicalSlot headerSlot = (HierarchicalSlot)this.method_7611(startSlotIndex);
        headerSlot.setParentSlot(parentSlot);
        int activeAttachmentCount = 0;
        for (int attachmentSlotIndex = 1; attachmentSlotIndex < container.method_5439(); ++attachmentSlotIndex) {
            int absoluteSlotIndex = startSlotIndex + attachmentSlotIndex;
            AttachmentSlot slot = (AttachmentSlot)this.method_7611(absoluteSlotIndex);
            slot.clear();
            slot.setParentSlot(parentSlot);
            if (attachmentSlotIndex - 1 < virtualInventory.getElements().size()) {
                AttachmentCategory category = mapping.get(attachmentSlotIndex);
                if (category != null) {
                    VirtualInventory mappedElement = virtualInventory.getElement(category);
                    if (mappedElement != null) {
                        int subIndex;
                        container.method_5447(attachmentSlotIndex, mappedElement.getItemStack().method_7972());
                        LOGGER.debug("Updated slot #{} in container {} with item {}", (Object)attachmentSlotIndex, (Object)container, (Object)container.method_5438(attachmentSlotIndex));
                        if (!mappedElement.getElements().isEmpty() && (subIndex = this.updateAttachmentSlots(slot, container, mappedElement, maxContainerIndex + 1)) > maxContainerIndex) {
                            maxContainerIndex = subIndex;
                        }
                    }
                } else {
                    container.method_5447(attachmentSlotIndex, class_1799.field_8037);
                    LOGGER.debug("Updated slot #{} in container {} with empty item {}", (Object)attachmentSlotIndex, (Object)container, (Object)container.method_5438(attachmentSlotIndex));
                }
                slot.setActive(true);
                ++activeAttachmentCount;
                continue;
            }
            slot.setActive(false);
        }
        LOGGER.debug("Container active attachment count: {} in container {}", (Object)activeAttachmentCount, (Object)container);
        ((Activatable)this.method_7611(startSlotIndex)).setActive(activeAttachmentCount > 0);
        container.addListener(virtualInventory);
        LOGGER.debug("Updated attachment slots for container {}", (Object)container);
        return maxContainerIndex;
    }

    SlotMapping getSlotMapping() {
        return this.slotMapping;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7609(class_1263 inventory) {
        LOGGER.debug("Slots changed for container {}", (Object)inventory);
        super.method_7623();
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 copyStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            copyStack = slotStack.method_7972();
            if (slotIndex < this.totalAttachmentSlots ? !this.method_7616(slotStack, this.totalAttachmentSlots, this.field_7761.size(), true) : !this.method_7616(slotStack, 0, this.totalAttachmentSlots, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return copyStack;
    }
}

