/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.feature;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.feature.ConditionContext;
import com.vicmatskiv.pointblank.feature.ConditionalFeature;
import com.vicmatskiv.pointblank.feature.FeatureBuilder;
import com.vicmatskiv.pointblank.feature.FeatureProvider;
import com.vicmatskiv.pointblank.util.Conditions;
import com.vicmatskiv.pointblank.util.JsonUtil;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public final class PipFeature
extends ConditionalFeature {
    private final float zoom;
    private final class_2960 overlayTexture;
    private final class_2960 maskTexture;
    private final boolean isParallaxEnabled;

    private PipFeature(FeatureProvider owner, Predicate<ConditionContext> condition, float zoom, boolean isParallaxEnabled, class_2960 overlayTexture, class_2960 maskTexture) {
        super(owner, condition);
        this.zoom = zoom;
        this.isParallaxEnabled = isParallaxEnabled;
        this.overlayTexture = overlayTexture;
        this.maskTexture = maskTexture;
    }

    public class_5250 getDescription() {
        return class_2561.method_43471((String)"description.pointblank.enablesPipWithZoom").method_10852((class_2561)class_2561.method_43470((String)String.format(" %.0f%%", Float.valueOf(this.zoom * 100.0f))));
    }

    public float getZoom() {
        return this.zoom;
    }

    public class_2960 getMaskTexture() {
        return this.maskTexture;
    }

    public boolean isParallaxEnabled() {
        return this.isParallaxEnabled;
    }

    public class_2960 getOverlayTexture() {
        return this.overlayTexture;
    }

    public static Optional<Float> getZoom(class_1799 itemStack) {
        FeatureProvider fp;
        PipFeature feature;
        Pair<String, class_1799> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        class_1799 selectedStack = null;
        selectedStack = selected != null ? (class_1799)selected.getSecond() : itemStack;
        class_1792 class_17922 = selectedStack.method_7909();
        if (class_17922 instanceof FeatureProvider && (feature = (fp = (FeatureProvider)class_17922).getFeature(PipFeature.class)) != null) {
            return Optional.of(Float.valueOf(feature.getZoom()));
        }
        return Optional.empty();
    }

    public static class_2960 getMaskTexture(class_1799 itemStack) {
        FeatureProvider fp;
        PipFeature feature;
        Pair<String, class_1799> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        class_1799 selectedStack = null;
        selectedStack = selected != null ? (class_1799)selected.getSecond() : itemStack;
        class_1792 class_17922 = selectedStack.method_7909();
        if (class_17922 instanceof FeatureProvider && (feature = (fp = (FeatureProvider)class_17922).getFeature(PipFeature.class)) != null) {
            return feature.getMaskTexture();
        }
        return null;
    }

    public static PipFeature getSelected(class_1799 itemStack) {
        Pair<String, class_1799> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        class_1799 selectedStack = null;
        if (selected == null) {
            return null;
        }
        selectedStack = (class_1799)selected.getSecond();
        class_1792 class_17922 = selectedStack.method_7909();
        if (class_17922 instanceof FeatureProvider) {
            FeatureProvider fp = (FeatureProvider)class_17922;
            return fp.getFeature(PipFeature.class);
        }
        return null;
    }

    public static class Builder
    implements FeatureBuilder<Builder, PipFeature> {
        private static final float DEFAULT_ZOOM = 0.9f;
        private static final String DEFAULT_MASK_TEXTURE = "textures/gui/pip_mask_solid_rect.png";
        private Predicate<ConditionContext> condition = ctx -> true;
        private class_2960 overlayTexture;
        private class_2960 maskTexture;
        private float zoom;
        private boolean isParallaxEnabled;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withZoom(double zoom) {
            this.zoom = (float)zoom;
            return this;
        }

        public Builder withOverlayTexture(String texture) {
            this.overlayTexture = new class_2960("pointblank", texture);
            return this;
        }

        public Builder withMaskTexture(String texture) {
            this.maskTexture = new class_2960("pointblank", texture);
            return this;
        }

        public Builder withParallaxEnabled(boolean isParallaxEnabled) {
            this.isParallaxEnabled = isParallaxEnabled;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            String maskTextureName;
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson(obj.get("condition")));
            }
            this.isParallaxEnabled = JsonUtil.getJsonBoolean(obj, "parallax", false);
            this.isParallaxEnabled = JsonUtil.getJsonBoolean(obj, "parallax", false);
            String overlayTextureName = JsonUtil.getJsonString(obj, "overlayTexture", null);
            if (overlayTextureName != null) {
                this.withOverlayTexture(overlayTextureName);
            }
            if ((maskTextureName = JsonUtil.getJsonString(obj, "maskTexture", null)) == null && this.isParallaxEnabled) {
                maskTextureName = DEFAULT_MASK_TEXTURE;
            }
            if (maskTextureName != null) {
                this.withMaskTexture(maskTextureName);
            }
            this.withZoom(JsonUtil.getJsonFloat(obj, "zoom", 0.9f));
            return this;
        }

        @Override
        public PipFeature build(FeatureProvider featureProvider) {
            class_2960 maskTexture = this.maskTexture;
            if (maskTexture == null && this.isParallaxEnabled) {
                maskTexture = new class_2960("pointblank", DEFAULT_MASK_TEXTURE);
            }
            return new PipFeature(featureProvider, this.condition, this.zoom, this.isParallaxEnabled, this.overlayTexture, maskTexture);
        }
    }
}

