/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.vicmatskiv.pointblank.crafting.PointBlankIngredient;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.registry.RecipeTypeRegistry;
import com.vicmatskiv.pointblank.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_8566;

public class PointBlankRecipe
implements class_1860<class_1263> {
    private static final int MAX_INGREDIENTS = 10;
    private static Function<class_1937, Map<class_1792, PointBlankRecipe>> levelRecipesByItem = class_156.method_34866(level -> level.method_8433().method_30027(RecipeTypeRegistry.DEFAULT_RECIPE_TYPE.get()).stream().collect(Collectors.toMap(r -> r.getItem(), r -> r)));
    private static Function<class_1937, Map<class_2960, PointBlankRecipe>> levelRecipesById = class_156.method_34866(level -> level.method_8433().method_30027(RecipeTypeRegistry.DEFAULT_RECIPE_TYPE.get()).stream().collect(Collectors.toMap(r -> r.method_8114(), r -> r)));
    private static final int MAX_SIZE = 10;
    private final class_2960 id;
    private final String group;
    private final class_1799 result;
    private final class_1799 initializedItemStack;
    private final List<PointBlankIngredient> ingredients;
    private static class_2371<class_1856> defaultIngredients = class_2371.method_10212((Object)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620}), (Object[])new class_1856[0]);

    public static PointBlankRecipe getRecipe(class_1937 level, class_1792 item) {
        return levelRecipesByItem.apply(level).get(item);
    }

    public static PointBlankRecipe getRecipe(class_1937 level, class_2960 recipeId) {
        return levelRecipesById.apply(level).get(recipeId);
    }

    public static List<PointBlankRecipe> getRecipes(class_1937 level) {
        return new ArrayList<PointBlankRecipe>(levelRecipesById.apply(level).values());
    }

    public PointBlankRecipe(class_2960 recipeId, String group, class_1799 resultItemStack, List<PointBlankIngredient> ingredients) {
        this.id = recipeId;
        this.group = group;
        this.result = resultItemStack.method_7972();
        this.initializedItemStack = resultItemStack.method_7972();
        if (this.initializedItemStack.method_7909() instanceof GunItem) {
            GunItem.initStackForCrafting(this.initializedItemStack);
        }
        if (ingredients == null || ingredients.isEmpty()) {
            throw new IllegalArgumentException("Recipe ingredients are not set for item " + resultItemStack);
        }
        if (ingredients.size() > 10) {
            throw new IllegalArgumentException("Recipe ingredients for item " + resultItemStack + " exceed maximum allowed count of 10");
        }
        this.ingredients = ingredients;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return RecipeTypeRegistry.DEFAULT_SERIALIZER.get();
    }

    public String method_8112() {
        return this.group;
    }

    private class_1792 getItem() {
        return this.result.method_7909();
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.result.method_7972();
    }

    public class_1799 getInitializedStack() {
        return this.initializedItemStack;
    }

    public class_2371<class_1856> method_8117() {
        return defaultIngredients;
    }

    public List<PointBlankIngredient> getPointBlankIngredients() {
        return this.ingredients;
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public boolean canBeCrafted(class_1657 player) {
        return this.ingredients.stream().anyMatch(ingredient -> InventoryUtils.hasIngredient(player, ingredient));
    }

    public void removeIngredients(class_1657 player) {
        this.ingredients.stream().forEach(ingredient -> InventoryUtils.removeItem(player, ingredient::matches, ingredient.getCount()));
    }

    public class_1799 assemble(class_8566 craftingContainer, class_5455 registryAccess) {
        return this.result.method_7972();
    }

    public boolean method_8113(int m, int n) {
        return false;
    }

    public class_1799 method_8116(class_1263 container, class_5455 registryAccess) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public class_3956<?> method_17716() {
        return RecipeTypeRegistry.DEFAULT_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements class_1865<PointBlankRecipe> {
        public PointBlankRecipe fromJson(class_2960 recipeId, JsonObject jsonObject) {
            String s = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
            class_2371<PointBlankIngredient> ingredients = Serializer.itemsFromJson(class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for the recipe");
            }
            if (ingredients.size() > 10) {
                throw new JsonParseException("Too many ingredients for the recipe. The maximum is 10");
            }
            class_1799 itemstack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
            return new PointBlankRecipe(recipeId, s, itemstack, (List<PointBlankIngredient>)ingredients);
        }

        private static class_2371<PointBlankIngredient> itemsFromJson(JsonArray jsonArray) {
            class_2371 ingredients = class_2371.method_10211();
            for (int i = 0; i < jsonArray.size(); ++i) {
                PointBlankIngredient ingredient = PointBlankIngredient.fromJson(jsonArray.get(i));
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }

        public PointBlankRecipe fromNetwork(class_2960 recipeId, class_2540 byteBuf) {
            String recipeGroup = byteBuf.method_19772();
            int ingredientSize = byteBuf.method_10816();
            class_2371 ingredients = class_2371.method_10211();
            for (int j = 0; j < ingredientSize; ++j) {
                ingredients.add((Object)PointBlankIngredient.fromNetwork(byteBuf));
            }
            class_1799 recipeResult = byteBuf.method_10819();
            return new PointBlankRecipe(recipeId, recipeGroup, recipeResult, (List<PointBlankIngredient>)ingredients);
        }

        public void toNetwork(class_2540 byteBuf, PointBlankRecipe recipe) {
            byteBuf.method_10814(recipe.group);
            byteBuf.method_10804(recipe.ingredients.size());
            for (PointBlankIngredient ingredient : recipe.ingredients) {
                ingredient.toNetwork(byteBuf);
            }
            byteBuf.method_10793(recipe.result);
        }
    }
}

