/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public interface PointBlankIngredient {
    public List<class_1799> getItemStacks();

    public JsonElement toJson();

    public int getCount();

    default public boolean matches(class_1799 itemStack) {
        if (itemStack == null) {
            return false;
        }
        return this.getItemStacks().stream().anyMatch(ingredientStack -> ingredientStack.method_31574(itemStack.method_7909()));
    }

    public void toNetwork(class_2540 var1);

    public static PointBlankIngredient of(class_6862<class_1792> tagKey, int count) {
        return new TagIngredient(tagKey, count);
    }

    public static PointBlankIngredient of(class_1935 itemLike, int count) {
        return new ItemIngredient(new class_1799(itemLike, count));
    }

    public static PointBlankIngredient fromNetwork(class_2540 byteBuf) {
        boolean isItem = byteBuf.readBoolean();
        if (isItem) {
            return ItemIngredient.fromNetwork(byteBuf);
        }
        return TagIngredient.fromNetwork(byteBuf);
    }

    public static PointBlankIngredient fromJson(JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull() || !jsonElement.isJsonObject()) {
            throw new JsonSyntaxException("Invalid json ingredient element: " + jsonElement);
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has("item") && jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (jsonObject.has("item")) {
            return ItemIngredient.fromJson(jsonObject);
        }
        if (jsonObject.has("tag")) {
            return TagIngredient.fromJson(jsonObject);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    public static class TagIngredient
    implements PointBlankIngredient {
        private final class_6862<class_1792> tagKey;
        private final int count;
        private final List<class_1799> itemStacks;

        private TagIngredient(class_6862<class_1792> tagKey, int count) {
            this.tagKey = tagKey;
            this.count = count;
            this.itemStacks = new ArrayList<class_1799>();
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public List<class_1799> getItemStacks() {
            if (this.itemStacks.isEmpty()) {
                for (class_6880 holder : class_7923.field_41178.method_40286(this.tagKey)) {
                    this.itemStacks.add(new class_1799((class_1935)holder.comp_349(), this.count));
                }
            }
            return this.itemStacks;
        }

        @Override
        public JsonElement toJson() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", this.tagKey.comp_327().toString());
            jsonObject.addProperty("count", (Number)this.count);
            return jsonObject;
        }

        public static PointBlankIngredient fromJson(JsonObject jsonObject) {
            String tagResourceLocation = JsonUtil.getJsonString(jsonObject, "tag", null);
            if (tagResourceLocation == null) {
                throw new JsonSyntaxException("Missing ingredient tag");
            }
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Platform.getInstance().parseRecipeResourceLocation(tagResourceLocation));
            int count = JsonUtil.getJsonInt(jsonObject, "count", 1);
            return new TagIngredient((class_6862<class_1792>)tagKey, count);
        }

        @Override
        public final void toNetwork(class_2540 byteBuf) {
            byteBuf.writeBoolean(false);
            byteBuf.method_10812(this.tagKey.comp_327());
            byteBuf.writeInt(this.count);
        }

        public static PointBlankIngredient fromNetwork(class_2540 byteBuf) {
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Platform.getInstance().parseRecipeResourceLocation(byteBuf.method_10810().toString()));
            int count = byteBuf.readInt();
            return new TagIngredient((class_6862<class_1792>)tagKey, count);
        }
    }

    public static class ItemIngredient
    implements PointBlankIngredient {
        private class_1799 itemStack;

        public ItemIngredient(class_1799 itemStack) {
            this.itemStack = itemStack;
        }

        @Override
        public int getCount() {
            return this.itemStack.method_7947();
        }

        @Override
        public List<class_1799> getItemStacks() {
            return Collections.singletonList(this.itemStack);
        }

        @Override
        public JsonElement toJson() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", class_7923.field_41178.method_10221((Object)this.itemStack.method_7909()).toString());
            jsonObject.addProperty("count", (Number)this.itemStack.method_7947());
            return jsonObject;
        }

        public static PointBlankIngredient fromJson(JsonObject jsonObject) {
            String itemLocation = JsonUtil.getJsonString(jsonObject, "item", null);
            if (itemLocation == null) {
                throw new JsonSyntaxException("Missing ingredient tag");
            }
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(itemLocation));
            int count = JsonUtil.getJsonInt(jsonObject, "count", 1);
            return new ItemIngredient(new class_1799((class_1935)item, count));
        }

        @Override
        public final void toNetwork(class_2540 byteBuf) {
            byteBuf.writeBoolean(true);
            byteBuf.method_10793(this.itemStack);
        }

        public static PointBlankIngredient fromNetwork(class_2540 byteBuf) {
            return new ItemIngredient(byteBuf.method_10819());
        }
    }
}

