/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.compat.iris;

import com.vicmatskiv.pointblank.compat.iris.GlslPatcher;
import com.vicmatskiv.pointblank.compat.iris.mixin.RenderTargetSettingsMixin;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.gl.texture.InternalTextureFormat;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shaderpack.properties.PackRenderTargetDirectives;
import net.irisshaders.iris.shaderpack.properties.ShaderProperties;
import net.irisshaders.iris.targets.RenderTargets;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class IrisShaderUtil {
    public static final String GLSL_VAR_AUX_POINTBLANK_TEX_COORD = "auxPointblankTexCoord";

    public static ProgramSource createProgramSource(String name, String vertexShaderSource, String fragmentShaderSource, ProgramSet parent, Supplier<ShaderProperties> shaderPropertiesSupplier, BlendModeOverride defaultBlendModeOverride) {
        return new ProgramSource(name, vertexShaderSource, null, null, null, fragmentShaderSource, parent, shaderPropertiesSupplier.get(), defaultBlendModeOverride);
    }

    public static String getResource(String resourceName) throws IOException {
        return new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(IrisShaderUtil.class.getResourceAsStream(resourceName))), StandardCharsets.UTF_8);
    }

    public static String replaceRenderTargets(String template, int value) {
        String pattern = "/* RENDERTARGETS: {} */";
        String replacement = "/* RENDERTARGETS: " + value + " */";
        return template.replace(pattern, replacement);
    }

    public static int findAvailableRenderTarget(ProgramSet programSet, RenderTargets renderTargets) {
        final Map renderTargetSettings = programSet.getPackDirectives().getRenderTargetDirectives().getRenderTargetSettings();
        ArrayList<Integer> availableIndices = new ArrayList<Integer>();
        for (int i = 4; i < 16; ++i) {
            if (renderTargets.get(i) != null) continue;
            availableIndices.add(i);
        }
        availableIndices.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return Integer.compare(this.getPriority(i1), this.getPriority(i2));
            }

            private int getPriority(int index) {
                PackRenderTargetDirectives.RenderTargetSettings settings = (PackRenderTargetDirectives.RenderTargetSettings)renderTargetSettings.get(index);
                if (settings != null) {
                    boolean isRGBA;
                    boolean shouldClear = settings.shouldClear();
                    boolean bl = isRGBA = settings.getInternalFormat() == InternalTextureFormat.RGBA;
                    if (shouldClear && isRGBA) {
                        return 0;
                    }
                    if (isRGBA) {
                        return 1;
                    }
                    if (shouldClear) {
                        return 2;
                    }
                    return 3;
                }
                return 4;
            }
        });
        if (!availableIndices.isEmpty()) {
            int index = (Integer)availableIndices.get(0);
            PackRenderTargetDirectives.RenderTargetSettings settings = (PackRenderTargetDirectives.RenderTargetSettings)renderTargetSettings.get(index);
            if (settings != null && !settings.shouldClear()) {
                ((RenderTargetSettingsMixin)settings).setClear(true);
            }
            return index;
        }
        return -1;
    }

    @NotNull
    public static String patchFinalPassVertexShader(String vsh, String auxPointblankTexCoordVar) {
        vsh = GlslPatcher.appendBeforeUniformDeclaration(vsh, "out vec2 " + auxPointblankTexCoordVar + ";\n");
        vsh = GlslPatcher.appendToMain(vsh, auxPointblankTexCoordVar + " = (mat4(1.0f) * vec4(UV0, 0.0f, 1.0f)).xy;\n");
        return vsh;
    }

    @NotNull
    public static String patchFinalPassFragmentShader(String fsh, String auxPointblankTexCoordVar, int auxIndex) {
        String colorTexIdentifierName;
        if (!GlslPatcher.containsIdentifier(fsh = GlslPatcher.appendBeforeUniformDeclaration(fsh, "in vec2 " + auxPointblankTexCoordVar + ";\n"), colorTexIdentifierName = "colortex" + auxIndex)) {
            fsh = GlslPatcher.appendBeforeSamplerDeclaration(fsh, "uniform sampler2D " + colorTexIdentifierName + ";\n");
        }
        String outIdentifier = "iris_FragData0";
        String color = null;
        if (GlslPatcher.containsIdentifier(fsh, outIdentifier)) {
            color = "vec4 pointblankAuxColor = texture(colortex" + auxIndex + ", " + auxPointblankTexCoordVar + ");\nif (pointblankAuxColor.a > 0.0) " + outIdentifier + " = pointblankAuxColor;\n";
        } else {
            List<String> layoutVars = GlslPatcher.extractVec3LayoutVariables(fsh);
            if (!layoutVars.isEmpty()) {
                outIdentifier = layoutVars.get(0);
                color = "vec4 pointblankAuxColor = texture(colortex" + auxIndex + ", " + auxPointblankTexCoordVar + ");\nif (pointblankAuxColor.a > 0.0) " + outIdentifier + " = pointblankAuxColor.xyz;\n";
            }
        }
        if (color != null) {
            fsh = GlslPatcher.appendToMain(fsh, color);
        }
        return fsh;
    }
}

