/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render.layer;

import com.vicmatskiv.pointblank.client.render.Flushable;
import com.vicmatskiv.pointblank.client.render.GunItemRenderer;
import com.vicmatskiv.pointblank.client.render.HierarchicalRenderContext;
import com.vicmatskiv.pointblank.client.render.RenderPass;
import com.vicmatskiv.pointblank.client.render.RenderTypeProvider;
import com.vicmatskiv.pointblank.client.render.layer.FeaturePassLayer;
import com.vicmatskiv.pointblank.feature.PipFeature;
import com.vicmatskiv.pointblank.item.GunItem;
import java.util.Collections;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;

public class PipItemLayer
extends FeaturePassLayer<GunItem> {
    private RenderPass currentRenderPass = RenderPass.PIP;

    public PipItemLayer(GunItemRenderer renderer) {
        super(renderer, PipFeature.class, RenderPass.PIP, Collections.singleton("scopepip"), true, null);
    }

    @Override
    public class_1921 getRenderType() {
        return RenderTypeProvider.NO_RENDER_TYPE;
    }

    @Override
    public RenderPass getRenderPass() {
        return this.currentRenderPass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(BakedGeoModel attachmentModel, class_4587 poseStack, class_4597 bufferSource, GunItem animatable, class_1921 renderType, class_4588 ignoredBuffer, float partialTick, int packedLight, int overlay, float red, float green, float blue, float alpha) {
        class_310 mc = class_310.method_1551();
        PipFeature pipFeature = PipFeature.getSelected(HierarchicalRenderContext.getRootItemStack());
        if (pipFeature == null) {
            return;
        }
        this.currentRenderPass = RenderPass.PIP;
        class_2960 maskTexture = pipFeature.getMaskTexture();
        class_2960 overlayTexture = pipFeature.getOverlayTexture();
        boolean isParallaxEnabled = pipFeature.isParallaxEnabled();
        if (maskTexture != null) {
            RenderPass.push(RenderPass.PIP_MASK);
            this.currentRenderPass = RenderPass.PIP_MASK;
            try {
                class_1921 maskRenderType = RenderTypeProvider.getInstance().getPipMaskRenderType(maskTexture);
                class_4588 maskBuffer = bufferSource.getBuffer(maskRenderType);
                super.render(attachmentModel, poseStack, bufferSource, (GeoAnimatable)animatable, maskRenderType, maskBuffer, partialTick, packedLight, overlay, red, green, blue, alpha);
                if (bufferSource instanceof Flushable) {
                    Flushable flushable = (Flushable)bufferSource;
                    flushable.flush();
                }
            }
            finally {
                RenderPass.pop();
                this.currentRenderPass = RenderPass.PIP;
            }
        }
        class_1921 pipRenderType = RenderTypeProvider.getInstance().getPipRenderType(maskTexture != null);
        super.render(attachmentModel, poseStack, bufferSource, (GeoAnimatable)animatable, pipRenderType, bufferSource.getBuffer(pipRenderType), partialTick, packedLight, overlay, red, green, blue, alpha);
        if (bufferSource instanceof Flushable) {
            Flushable flushable = (Flushable)bufferSource;
            flushable.flush();
        }
        if (overlayTexture != null) {
            try (HierarchicalRenderContext subHrc = HierarchicalRenderContext.push();){
                subHrc.setAttribute("is_parallax_enabled", isParallaxEnabled);
                RenderPass.push(RenderPass.PIP_OVERLAY);
                this.currentRenderPass = RenderPass.PIP_OVERLAY;
                try {
                    class_1921 overlayRenderType = RenderTypeProvider.getInstance().getPipOverlayRenderType(overlayTexture, maskTexture != null);
                    class_4588 overlayBuffer = bufferSource.getBuffer(overlayRenderType);
                    super.render(attachmentModel, poseStack, bufferSource, (GeoAnimatable)animatable, overlayRenderType, overlayBuffer, partialTick, packedLight, overlay, red, green, blue, alpha);
                    if (bufferSource instanceof Flushable) {
                        Flushable flushable = (Flushable)bufferSource;
                        flushable.flush();
                    }
                }
                finally {
                    RenderPass.pop();
                    this.currentRenderPass = RenderPass.PIP;
                }
            }
        }
    }

    @Override
    public boolean isSupportedItemDisplayContext(class_811 context) {
        return context == class_811.field_4321 || context == class_811.field_4322;
    }

    public static boolean isParallaxEnabled() {
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        Boolean isParallaxEnabled = (Boolean)current.getAttribute("is_parallax_enabled");
        return isParallaxEnabled != null && isParallaxEnabled != false;
    }
}

