/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.attachment;

import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.AttachmentHost;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.client.ClientSystem;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.util.LRUCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.util.RenderUtils;

public record AttachmentModelInfo(BakedGeoModel baseModel, CoreGeoBone baseBone, BakedGeoModel attachmentModel, CoreGeoBone attachmentBone) {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static final String PREFIX_CONNECTOR_BASE = "_cb_";
    private static final String PREFIX_CONNECTOR_ATTACHMENT = "_ca_";
    private static final LRUCache<class_2520, NavigableMap<String, Pair<class_1799, Matrix4f>>> stackTagPosisionCache = new LRUCache(100);
    public static final Function<ModelBoneKey, Optional<Pair<Matrix4f, Matrix4f>>> modelBonePositions = class_156.method_34866(AttachmentModelInfo::getRefBoneMatrices);
    private static final BiFunction<BakedGeoModel, String, Optional<? extends CoreGeoBone>> modelBones = class_156.method_34865((model, boneName) -> model.getBone(boneName));
    public static final BiFunction<AttachmentHost, Attachment, Optional<AttachmentModelInfo>> attachmentInfos = ClientSystem.getInstance().createReloadableMemoize(AttachmentModelInfo::getAttachmentModelInfo);
    private static final Function<BakedGeoModel, List<? extends CoreGeoBone>> modelABBones = class_156.method_34866(model -> AttachmentModelInfo.findBones(model, b -> b.getName().startsWith(PREFIX_CONNECTOR_ATTACHMENT)));

    private static Optional<AttachmentModelInfo> getAttachmentModelInfo(AttachmentHost attachmentHost, Attachment attachment) {
        AttachmentModelInfo attachmentInfo = null;
        BakedGeoModel attachmentModel = AttachmentModelInfo.getModel(attachment.getName());
        if (attachmentModel != null) {
            BakedGeoModel baseModel = AttachmentModelInfo.getModel(attachmentHost.getName());
            for (CoreGeoBone coreGeoBone : modelABBones.apply(attachmentModel)) {
                String suffix = coreGeoBone.getName().substring(PREFIX_CONNECTOR_ATTACHMENT.length());
                CoreGeoBone baseBone = modelBones.apply(baseModel, PREFIX_CONNECTOR_BASE + suffix).orElse(null);
                if (baseBone == null) continue;
                attachmentInfo = new AttachmentModelInfo(baseModel, baseBone, attachmentModel, coreGeoBone);
                break;
            }
        }
        return Optional.ofNullable(attachmentInfo);
    }

    private static List<? extends CoreGeoBone> findBones(BakedGeoModel model, Predicate<CoreGeoBone> predicate) {
        if (model == null) {
            return null;
        }
        return AttachmentModelInfo.findBonesRecursively(() -> ((BakedGeoModel)model).getBones(), predicate, new ArrayList<CoreGeoBone>());
    }

    private static List<? extends CoreGeoBone> findBonesRecursively(Supplier<List<? extends CoreGeoBone>> boneListSupplier, Predicate<CoreGeoBone> predicate, List<CoreGeoBone> results) {
        for (CoreGeoBone coreGeoBone : boneListSupplier.get()) {
            if (predicate.test(coreGeoBone)) {
                results.add(coreGeoBone);
            }
            AttachmentModelInfo.findBonesRecursively(() -> ((CoreGeoBone)coreGeoBone).getChildBones(), predicate, results);
        }
        return results;
    }

    public static BakedGeoModel getModel(String itemName) {
        class_2960 attachmentModelResource = new class_2960("pointblank", "geo/item/" + itemName + ".geo.json");
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(attachmentModelResource);
    }

    public static Optional<Pair<Matrix4f, Matrix4f>> getRefBoneMatrices(ModelBoneKey key) {
        List cubes;
        Pair result = null;
        GeoBone bone = key.model.getBone(key.boneName).orElse(null);
        if (bone != null && (cubes = bone.getCubes()) != null && !cubes.isEmpty()) {
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad upQuad = cube.quads()[4];
            GeoQuad downQuad = cube.quads()[5];
            GeoVertex[] upVertices = upQuad.vertices();
            GeoVertex[] downVertices = downQuad.vertices();
            GeoVertex upVertex = upVertices[0];
            GeoVertex downVertex = downVertices[0];
            Vector3f position = new Vector3f((Vector3fc)upVertex.position()).add((Vector3fc)downVertex.position()).mul(0.5f);
            position.mul(key.scale);
            Matrix4f m = new Matrix4f().translate((Vector3fc)position);
            class_243 cubeRotation = cube.rotation();
            if (cubeRotation.field_1350 != 0.0) {
                m.rotate((Quaternionfc)class_7833.field_40718.rotation((float)cubeRotation.field_1350));
            }
            if (cubeRotation.field_1351 != 0.0) {
                m.rotate((Quaternionfc)class_7833.field_40716.rotation((float)cubeRotation.field_1351));
            }
            if (cubeRotation.field_1352 != 0.0) {
                m.rotate((Quaternionfc)class_7833.field_40714.rotation((float)cubeRotation.field_1352));
            }
            result = Pair.of((Object)m, (Object)new Matrix4f((Matrix4fc)m).invert());
        }
        return Optional.ofNullable(result);
    }

    public static NavigableMap<String, Pair<class_1799, Matrix4f>> findInverseBoneMatrices(class_1799 baseStack, String boneName, float scale) {
        GunItem gunItem;
        BakedGeoModel gunItemModel;
        class_1792 class_17922;
        if (baseStack != null && (class_17922 = baseStack.method_7909()) instanceof GunItem && (gunItemModel = AttachmentModelInfo.getModel((gunItem = (GunItem)class_17922).getName())) != null) {
            return AttachmentModelInfo.findInverseBoneMatrices(baseStack, gunItemModel, boneName, scale);
        }
        return Collections.emptyNavigableMap();
    }

    private static NavigableMap<String, Pair<class_1799, Matrix4f>> findInverseBoneMatrices(class_1799 baseStack, BakedGeoModel baseModel, String boneName, float scale) {
        class_2487 tag = baseStack.method_7969();
        TreeMap<String, Pair<class_1799, Matrix4f>> results = new TreeMap<String, Pair<class_1799, Matrix4f>>();
        if (tag == null) {
            return results;
        }
        class_2520 attachmentsTag = tag.method_10580("as");
        if (attachmentsTag == null) {
            attachmentsTag = tag;
        }
        class_2487 keyTag = new class_2487();
        keyTag.method_10566("a", attachmentsTag);
        class_2520 selectedAttachments = tag.method_10580("sa");
        if (selectedAttachments != null) {
            keyTag.method_10566("sa", tag.method_10580("sa"));
        }
        keyTag.method_10544("m", tag.method_10537("mid"));
        keyTag.method_10544("l", tag.method_10537("lid"));
        return stackTagPosisionCache.computeIfAbsent((class_2520)keyTag, t -> AttachmentModelInfo.findBonePositions(baseModel, "/", baseStack, boneName, scale, new class_4587(), results));
    }

    private static NavigableMap<String, Pair<class_1799, Matrix4f>> findBonePositions(BakedGeoModel baseModel, String componentName, class_1799 baseStack, String boneName, float scale, class_4587 poseStack, NavigableMap<String, Pair<class_1799, Matrix4f>> results) {
        class_1792 class_17922;
        LOGGER.debug("Computing inverse bone position for component {}", (Object)componentName);
        Pair abPos = modelBonePositions.apply(new ModelBoneKey(baseModel, boneName, scale)).orElse(null);
        if (abPos != null) {
            poseStack.method_22903();
            poseStack.method_34425((Matrix4f)abPos.getFirst());
            results.put(componentName, (Pair<class_1799, Matrix4f>)Pair.of((Object)baseStack, (Object)new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761()).invert()));
            poseStack.method_22909();
        }
        if (!((class_17922 = baseStack.method_7909()) instanceof AttachmentHost)) {
            return results;
        }
        AttachmentHost attachmentHost = (AttachmentHost)class_17922;
        Collection attachmentStacks = Attachments.getAttachments(baseStack.method_7969(), "/", false, new TreeMap<String, class_1799>()).values();
        for (class_1799 attachmentStack : attachmentStacks) {
            Attachment attachment;
            AttachmentModelInfo attachmentInfo;
            class_1792 class_17923 = attachmentStack.method_7909();
            if (!(class_17923 instanceof Attachment) || (attachmentInfo = (AttachmentModelInfo)attachmentInfos.apply(attachmentHost, attachment = (Attachment)class_17923).orElse(null)) == null) continue;
            Pair basePos = modelBonePositions.apply(new ModelBoneKey(attachmentInfo.baseModel(), attachmentInfo.baseBone().getName(), scale)).orElse(null);
            BakedGeoModel attachmentModel = attachmentInfo.attachmentModel();
            Pair attachmentPos = modelBonePositions.apply(new ModelBoneKey(attachmentModel, attachmentInfo.attachmentBone().getName(), scale)).orElse(null);
            if (basePos == null || attachmentPos == null) continue;
            poseStack.method_22903();
            poseStack.method_34425((Matrix4f)basePos.getFirst());
            poseStack.method_34425((Matrix4f)attachmentPos.getSecond());
            AttachmentModelInfo.findBonePositions(attachmentModel, componentName + "/" + attachment.getName(), attachmentStack, boneName, scale, poseStack, results);
            poseStack.method_22909();
        }
        return results;
    }

    public static List<CoreGeoBone> getParentBoneHierarchy(CoreGeoBone bone) {
        LinkedList<CoreGeoBone> result = new LinkedList<CoreGeoBone>();
        for (CoreGeoBone current = bone; current != null; current = current.getParent()) {
            result.addFirst(current);
        }
        return result;
    }

    public static void preparePoseStackForBoneInHierarchy(class_4587 poseStack, CoreGeoBone bone) {
        List<CoreGeoBone> boneHierarchy = AttachmentModelInfo.getParentBoneHierarchy(bone);
        for (CoreGeoBone parentBone : boneHierarchy) {
            RenderUtils.prepMatrixForBone((class_4587)poseStack, (CoreGeoBone)parentBone);
        }
    }

    public static class ModelBoneKey {
        BakedGeoModel model;
        String boneName;
        float scale;

        public ModelBoneKey(BakedGeoModel model, String boneName, float scale) {
            this.model = model;
            this.boneName = boneName;
            this.scale = scale;
        }

        public int hashCode() {
            return Objects.hash(this.boneName, this.model, Float.valueOf(this.scale));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModelBoneKey other = (ModelBoneKey)obj;
            return Objects.equals(this.boneName, other.boneName) && Objects.equals(this.model, other.model) && Float.floatToIntBits(this.scale) == Float.floatToIntBits(other.scale);
        }
    }
}

