/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Max;
import de.maxhenkel.admiral.annotations.Min;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.OptionalArgument;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.audioplayer.AudioManager;
import de.maxhenkel.audioplayer.AudioPlayer;
import de.maxhenkel.audioplayer.CustomSound;
import de.maxhenkel.audioplayer.VolumeOverrideManager;
import de.maxhenkel.audioplayer.command.UtilityCommands;
import java.text.DecimalFormat;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

@Command(value={"audioplayer"})
public class VolumeCommands {
    @RequiresPermission(value="audioplayer.volume")
    @Command(value={"volume"})
    public void volumeWithId(CommandContext<class_2168> context, @Name(value="id") UUID uuid, @OptionalArgument @Name(value="volume") @Min(value="0.01") @Max(value="100") Float volume) {
        this.volumeCommand(context, uuid, volume);
    }

    @RequiresPermission(value="audioplayer.volume")
    @Command(value={"volume"})
    public void volumeHeldItem(CommandContext<class_2168> context, @OptionalArgument @Name(value="volume") @Min(value="0.01") @Max(value="100") Float volume) throws CommandSyntaxException {
        CustomSound customSound = UtilityCommands.getHeldSound(context);
        if (customSound == null) {
            return;
        }
        this.volumeCommand(context, customSound.getSoundId(), volume);
    }

    private void volumeCommand(CommandContext<class_2168> context, UUID id, @Nullable Float volume) {
        if (!AudioManager.checkSoundExists(((class_2168)context.getSource()).method_9211(), id)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Sound does not exist"));
            return;
        }
        Optional<VolumeOverrideManager> optionalMgr = VolumeOverrideManager.instance();
        if (optionalMgr.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"An internal error occurred"));
            return;
        }
        VolumeOverrideManager mgr = optionalMgr.get();
        DecimalFormat percentFormat = new DecimalFormat("#.00");
        if (volume == null) {
            float currentVolumeLog = mgr.getAudioVolume(id);
            float currentVolume = VolumeOverrideManager.convertToLinearScaleFactor(currentVolumeLog);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Current volume is %s%%".formatted(percentFormat.format(currentVolume * 100.0f))), false);
            return;
        }
        if (volume.floatValue() == 100.0f) {
            mgr.setAudioVolume(id, null);
        }
        float volumeLinear = volume.floatValue() / 100.0f;
        mgr.setAudioVolume(id, Float.valueOf(VolumeOverrideManager.convertToLogarithmicScaleFactor(volumeLinear)));
        AudioPlayer.AUDIO_CACHE.remove(id);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully set sound volume to %s%%, this will apply next time the sound plays".formatted(percentFormat.format(volume))), false);
    }
}

