/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import de.maxhenkel.audioplayer.AudioPlayer;
import de.maxhenkel.audioplayer.Plugin;
import de.maxhenkel.voicechat.api.mp3.Mp3Decoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioConverter {
    public static AudioFormat FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 1, 2, 48000.0f, false);

    @Nullable
    public static AudioType getAudioType(Path path) throws IOException {
        if (AudioConverter.isWav(Files.newInputStream(path, new OpenOption[0]))) {
            return AudioType.WAV;
        }
        if (AudioConverter.isMp3File(Files.newInputStream(path, new OpenOption[0]))) {
            return AudioType.MP3;
        }
        return null;
    }

    @Nullable
    public static AudioType getAudioType(byte[] data) throws IOException {
        if (AudioConverter.isWav(new ByteArrayInputStream(data))) {
            return AudioType.WAV;
        }
        if (AudioConverter.isMp3File(new ByteArrayInputStream(data))) {
            return AudioType.MP3;
        }
        return null;
    }

    public static boolean isWav(InputStream inputStream) throws IOException {
        boolean bl;
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        try {
            AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(bis);
            bl = fileFormat.getType().toString().equalsIgnoreCase("wave");
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedAudioFileException e) {
                return false;
            }
        }
        bis.close();
        return bl;
    }

    public static boolean isMp3File(InputStream inputStream) throws IOException {
        boolean bl;
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        try {
            AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(bis);
            bl = fileFormat.getType().toString().equalsIgnoreCase("mp3");
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedAudioFileException e) {
                return false;
            }
        }
        bis.close();
        return bl;
    }

    public static short[] convert(Path file, float volume) throws IOException, UnsupportedAudioFileException {
        return AudioConverter.convert(file, AudioConverter.getAudioType(file), volume);
    }

    public static short[] convert(Path file, AudioType audioType, float volume) throws IOException, UnsupportedAudioFileException {
        if (audioType == AudioType.WAV) {
            return AudioConverter.convertWav(file, volume);
        }
        if (audioType == AudioType.MP3) {
            return AudioConverter.convertMp3(file, volume);
        }
        throw new UnsupportedAudioFileException("Unsupported audio type");
    }

    public static short[] convertWav(Path file, float volume) throws IOException, UnsupportedAudioFileException {
        try (AudioInputStream source = AudioSystem.getAudioInputStream(file.toFile());){
            short[] sArray = AudioConverter.convert(source, volume);
            return sArray;
        }
    }

    private static short[] convert(AudioInputStream source, float volume) throws IOException {
        AudioFormat sourceFormat = source.getFormat();
        AudioFormat convertFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), sourceFormat.getChannels() * 2, sourceFormat.getSampleRate(), false);
        AudioInputStream stream1 = AudioSystem.getAudioInputStream(convertFormat, source);
        AudioInputStream stream2 = AudioSystem.getAudioInputStream(FORMAT, stream1);
        return Plugin.voicechatApi.getAudioConverter().bytesToShorts(AudioConverter.adjustVolume(stream2.readAllBytes(), volume));
    }

    private static byte[] adjustVolume(byte[] audioSamples, float volume) {
        for (int i = 0; i < audioSamples.length; i += 2) {
            short buf1 = audioSamples[i + 1];
            short buf2 = audioSamples[i];
            buf1 = (short)((buf1 & 0xFF) << 8);
            buf2 = (short)(buf2 & 0xFF);
            short res = (short)(buf1 | buf2);
            res = (short)((float)res * volume);
            audioSamples[i] = (byte)res;
            audioSamples[i + 1] = (byte)(res >> 8);
        }
        return audioSamples;
    }

    public static short[] convertMp3(Path file, float volume) throws IOException, UnsupportedAudioFileException {
        try {
            Mp3Decoder mp3Decoder = Plugin.voicechatApi.createMp3Decoder(Files.newInputStream(file, new OpenOption[0]));
            if (mp3Decoder == null) {
                throw new IOException("Error creating mp3 decoder");
            }
            byte[] data = Plugin.voicechatApi.getAudioConverter().shortsToBytes(mp3Decoder.decode());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
            AudioFormat audioFormat = mp3Decoder.getAudioFormat();
            AudioInputStream source = new AudioInputStream(byteArrayInputStream, audioFormat, data.length / audioFormat.getFrameSize());
            return AudioConverter.convert(source, volume);
        }
        catch (Exception e) {
            AudioPlayer.LOGGER.warn("Error converting mp3 file with native decoder");
            return AudioConverter.convert(AudioSystem.getAudioInputStream(file.toFile()), volume);
        }
    }

    public static enum AudioType {
        MP3("mp3"),
        WAV("wav");

        private final String extension;

        private AudioType(String fileName) {
            this.extension = fileName;
        }

        public boolean isValidFileName(Path path) {
            return path.toString().toLowerCase().endsWith(".%s".formatted(this.extension));
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

